/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.embedded;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.ff4j.FF4j;
import org.ff4j.core.Feature;
import org.ff4j.property.Property;
import org.ff4j.web.ApiConfig;
import org.ff4j.web.FF4jInitServlet;
import org.ff4j.web.console.ImageProvider;
import org.ff4j.web.embedded.ConsoleOperations;
import org.ff4j.web.embedded.ConsoleRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.WebContext;

public class ConsoleServlet
extends FF4jInitServlet {
    private static final long serialVersionUID = -3982043895954284269L;
    public static final Logger LOGGER = LoggerFactory.getLogger(ConsoleServlet.class);
    public static final String ERROR = "error";

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (ConsoleRenderer.renderResources(req, res)) {
            return;
        }
        ServletContext sc = req.getSession().getServletContext();
        WebContext ctx = new WebContext(req, res, sc, req.getLocale());
        ctx.setVariable("CHAINE", (Object)"Sample Valeur");
        ApiConfig api = new ApiConfig();
        api.setHost("HOST_X");
        ctx.setVariable("BEAN", (Object)api);
        ctx.setVariable("today", (Object)Calendar.getInstance());
        ImageProvider.getInstance().addImageToContext(ctx, "flagFrance", ImageProvider.ImageType.png);
        ArrayList<ApiConfig> listA = new ArrayList<ApiConfig>();
        listA.add(new ApiConfig());
        listA.add(new ApiConfig());
        listA.add(api);
        ctx.setVariable("apis", listA);
        this.templateEngine.process("home", (IContext)ctx, (Writer)res.getWriter());
    }

    public void pageMonitoring(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String message = null;
        String messagetype = "info";
        ConsoleRenderer.renderPageMonitoring(this.getFf4j(), req, res, message, messagetype);
    }

    public void pageCore(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String message = null;
        String messagetype = "info";
        try {
            if (ConsoleRenderer.renderResources(req, res)) {
                return;
            }
            String operation = req.getParameter("op");
            String featureId = req.getParameter("uid");
            LOGGER.info("GET - op=" + operation + " feat=" + featureId);
            if (operation != null && !operation.isEmpty()) {
                if ("export".equalsIgnoreCase(operation)) {
                    ConsoleOperations.exportFile(this.ff4j, res);
                    return;
                }
                if (featureId != null && !featureId.isEmpty()) {
                    if (this.getFf4j().getFeatureStore().exist(featureId)) {
                        if ("disable".equalsIgnoreCase(operation)) {
                            this.getFf4j().disable(featureId);
                            res.setContentType("text/html");
                            res.getWriter().println(ConsoleRenderer.renderMessageBox(ConsoleRenderer.msg(featureId, "DISABLED"), "info"));
                            LOGGER.info(featureId + " has been disabled");
                            return;
                        }
                        if ("enable".equalsIgnoreCase(operation)) {
                            this.getFf4j().enable(featureId);
                            res.setContentType("text/html");
                            res.getWriter().println(ConsoleRenderer.renderMessageBox(ConsoleRenderer.msg(featureId, "ENABLED"), "info"));
                            LOGGER.info("Feature '" + featureId + "' has been successfully enabled");
                            return;
                        }
                        if ("readFeature".equalsIgnoreCase(operation)) {
                            Feature f = this.getFf4j().getFeatureStore().read(featureId);
                            res.setContentType("application/json");
                            res.getWriter().println(f.toJson());
                            return;
                        }
                        if ("delete".equalsIgnoreCase(operation)) {
                            this.getFf4j().getFeatureStore().delete(featureId);
                            message = ConsoleRenderer.msg(featureId, "DELETED");
                            LOGGER.info(featureId + " has been deleted");
                        }
                    }
                    if (this.getFf4j().getPropertiesStore().existProperty(featureId)) {
                        if ("deleteProperty".equalsIgnoreCase(operation)) {
                            this.getFf4j().getPropertiesStore().deleteProperty(featureId);
                            message = ConsoleRenderer.renderMsgProperty(featureId, "DELETED");
                            LOGGER.info("Property '" + featureId + "' has been deleted");
                        }
                        if ("readProperty".equalsIgnoreCase(operation)) {
                            Property ap = this.getFf4j().getPropertiesStore().readProperty(featureId);
                            res.setContentType("application/json");
                            res.getWriter().println(ap.toString());
                            return;
                        }
                        if ("deleteFixedValue".equalsIgnoreCase(operation)) {
                            String fixedValue = req.getParameter("fixedValue");
                            Property ap = this.getFf4j().getPropertiesStore().readProperty(featureId);
                            ap.getFixedValues().remove(fixedValue);
                            this.getFf4j().getPropertiesStore().updateProperty(ap);
                            return;
                        }
                        if ("addFixedValue".equalsIgnoreCase(operation)) {
                            String fixedValue = req.getParameter("fixedValue");
                            Property ap = this.getFf4j().getPropertiesStore().readProperty(featureId);
                            ap.add2FixedValueFromString(fixedValue);
                            this.getFf4j().getPropertiesStore().updateProperty(ap);
                            return;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            messagetype = ERROR;
            message = e.getMessage();
            LOGGER.error("An error occured ", (Throwable)e);
        }
        ConsoleRenderer.renderPage(this.getFf4j(), req, res, message, messagetype);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String message = null;
        String messagetype = "info";
        try {
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
                List items = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory()).parseRequest(req);
                for (FileItem item : items) {
                    if (item.isFormField()) {
                        if (!"op".equalsIgnoreCase(item.getFieldName())) continue;
                        LOGGER.info("Processing action : " + item.getString());
                        continue;
                    }
                    if (!"flipFile".equalsIgnoreCase(item.getFieldName())) continue;
                    String filename = FilenameUtils.getName((String)item.getName());
                    if (filename.toLowerCase().endsWith("xml")) {
                        ConsoleOperations.importFile(this.getFf4j(), item.getInputStream());
                        message = "The file <b>" + filename + "</b> has been successfully imported";
                        continue;
                    }
                    messagetype = ERROR;
                    message = "Invalid FILE, must be CSV, XML or PROPERTIES files";
                }
            } else {
                String operation = req.getParameter("op");
                String uid = req.getParameter("uid");
                LOGGER.info("POST - op=" + operation + " feat=" + uid);
                if (operation != null && !operation.isEmpty()) {
                    if ("update".equalsIgnoreCase(operation)) {
                        ConsoleOperations.updateFeatureDescription(this.getFf4j(), req);
                        message = ConsoleRenderer.msg(uid, "UPDATED");
                    } else if ("updateProperty".equalsIgnoreCase(operation)) {
                        ConsoleOperations.updateProperty(this.getFf4j(), req);
                        message = ConsoleRenderer.renderMsgProperty(uid, "UPDATED");
                    } else if ("createProperty".equalsIgnoreCase(operation)) {
                        ConsoleOperations.createProperty(this.getFf4j(), req);
                        message = ConsoleRenderer.renderMsgProperty(req.getParameter("name"), "ADDED");
                    } else if ("create".equalsIgnoreCase(operation)) {
                        ConsoleOperations.createFeature(this.getFf4j(), req);
                        message = ConsoleRenderer.msg(uid, "ADDED");
                    } else if ("toggleGroup".equalsIgnoreCase(operation)) {
                        String groupName = req.getParameter("groupName");
                        if (groupName != null && !groupName.isEmpty()) {
                            String operationGroup = req.getParameter("ope");
                            if ("enable".equalsIgnoreCase(operationGroup)) {
                                this.getFf4j().getFeatureStore().enableGroup(groupName);
                                message = ConsoleRenderer.renderMsgGroup(groupName, "ENABLED");
                                LOGGER.info("Group '" + groupName + "' has been ENABLED.");
                            } else if ("disable".equalsIgnoreCase(operationGroup)) {
                                this.getFf4j().getFeatureStore().disableGroup(groupName);
                                message = ConsoleRenderer.renderMsgGroup(groupName, "DISABLED");
                                LOGGER.info("Group '" + groupName + "' has been DISABLED.");
                            }
                        }
                    } else {
                        LOGGER.error("Invalid POST OPERATION" + operation);
                        messagetype = ERROR;
                        message = "Invalid REQUEST";
                    }
                } else {
                    LOGGER.error("No ID provided" + operation);
                    messagetype = ERROR;
                    message = "Invalid UID";
                }
            }
        }
        catch (Exception e) {
            messagetype = ERROR;
            message = e.getMessage();
            LOGGER.error("An error occured ", (Throwable)e);
        }
        ConsoleRenderer.renderPage(this.ff4j, req, res, message, messagetype);
    }

    public FF4j getFf4j() {
        if (this.ff4j == null) {
            throw new IllegalStateException("Console Servlet has not been initialized, please set 'load-at-startup' to 1");
        }
        return this.ff4j;
    }

    public void setFf4j(FF4j ff4j) {
        this.ff4j = ff4j;
    }
}

