/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.thymeleaf;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.messageresolver.IMessageResolver;

public class CustomMessageResolver
implements IMessageResolver {
    private static final String MSG_FILE = "ff4j-messages";
    private static final String MSG_FILE_EXTENSION = ".properties";
    public static final Logger LOGGER = LoggerFactory.getLogger(CustomMessageResolver.class);
    protected Map<String, Properties> messages = new HashMap<String, Properties>();
    protected final Properties defaultMessages = this.resolveProperties(Locale.ENGLISH);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        InputStream is = null;
        InputStreamReader r = null;
        try {
            String defaultMessageFilename = "ff4j-messages.properties";
            is = CustomMessageResolver.class.getClassLoader().getResourceAsStream(defaultMessageFilename);
            r = new InputStreamReader(is, "UTF-8");
            this.defaultMessages.load(r);
            LOGGER.debug("Default {} properties have been loaded from {}", (Object)this.defaultMessages.size(), (Object)defaultMessageFilename);
        }
        catch (IOException e) {
            LOGGER.error("Cannot load default properties", (Throwable)e);
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties resolveProperties(Locale locale) {
        Properties target;
        String lang = locale.getLanguage().toLowerCase();
        if (!this.messages.containsKey(lang)) {
            LOGGER.info("resolveProperties: {}", (Object)lang);
            this.messages.put(lang, null);
            String expectedFileName = "ff4j-messages_" + locale.getLanguage() + MSG_FILE_EXTENSION;
            InputStream is = CustomMessageResolver.class.getClassLoader().getResourceAsStream(expectedFileName);
            InputStreamReader r = null;
            if (is != null) {
                try {
                    r = "ar".equalsIgnoreCase(lang) ? new InputStreamReader(is, "UTF-16") : new InputStreamReader(is, "UTF-8");
                    Properties propsLocale = new Properties();
                    propsLocale.load(r);
                    LOGGER.info("{} properties loaded from {}", (Object)propsLocale.size(), (Object)expectedFileName);
                    this.messages.put(locale.getLanguage(), propsLocale);
                }
                catch (IOException e) {
                    LOGGER.error("Cannot load properties from " + expectedFileName, (Throwable)e);
                }
                finally {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            } else {
                LOGGER.info("No file found for Locale {} using default ", (Object)locale);
            }
        }
        return (target = this.messages.get(locale.getLanguage())) != null ? target : this.defaultMessages;
    }

    public String resolveMessage(ITemplateContext iTemplateContext, Class<?> aClass, String s, Object[] objects) {
        Locale locale = iTemplateContext.getLocale();
        String targetMsg = this.resolveProperties(locale).getProperty(s);
        if (targetMsg == null) {
            targetMsg = this.defaultMessages.getProperty(s);
        }
        if (targetMsg == null) {
            targetMsg = "key:" + s;
        }
        if (objects != null && objects.length > 0) {
            targetMsg = new MessageFormat(targetMsg, iTemplateContext.getLocale()).format(objects);
        }
        return targetMsg;
    }

    public String createAbsentMessageRepresentation(ITemplateContext iTemplateContext, Class<?> aClass, String s, Object[] objects) {
        return String.format("key:{}", s);
    }

    public Integer getOrder() {
        return 0;
    }

    public String getName() {
        return "customMessageResolver";
    }
}

