/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rs.client;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.net.URI;
import java.util.List;
import org.gedcomx.rs.client.AgentState;
import org.gedcomx.rs.client.AncestryResultsState;
import org.gedcomx.rs.client.CollectionState;
import org.gedcomx.rs.client.CollectionsState;
import org.gedcomx.rs.client.DescendancyResultsState;
import org.gedcomx.rs.client.GedcomxApplicationState;
import org.gedcomx.rs.client.PersonChildrenState;
import org.gedcomx.rs.client.PersonParentsState;
import org.gedcomx.rs.client.PersonSearchResultsState;
import org.gedcomx.rs.client.PersonSpousesState;
import org.gedcomx.rs.client.PersonState;
import org.gedcomx.rs.client.PersonsState;
import org.gedcomx.rs.client.PlaceDescriptionState;
import org.gedcomx.rs.client.PlaceDescriptionsState;
import org.gedcomx.rs.client.RecordState;
import org.gedcomx.rs.client.RecordsState;
import org.gedcomx.rs.client.RelationshipState;
import org.gedcomx.rs.client.RelationshipsState;
import org.gedcomx.rs.client.SourceDescriptionState;
import org.gedcomx.rs.client.SourceDescriptionsState;
import org.gedcomx.rs.client.VocabElementListState;
import org.gedcomx.rs.client.VocabElementState;
import org.gedcomx.rs.client.util.HttpWarning;
import org.gedcomx.rt.json.GedcomJsonProvider;
import org.gedcomx.rt.json.GedcomxAtomJsonProvider;
import org.gedcomx.rt.xml.GedcomxXmlProvider;

public class StateFactory {
    protected static final String ENABLE_JERSEY_LOGGING_ENV_NAME = "enableJerseyLogging";

    public CollectionState newCollectionState(URI discoveryUri) {
        return this.newCollectionState(discoveryUri, this.loadDefaultClient());
    }

    public CollectionState newCollectionState(URI discoveryUri, Client client) {
        return this.newCollectionState(discoveryUri, client, "GET");
    }

    public CollectionState newCollectionState(URI discoveryUri, Client client, String method) {
        ClientRequest request = ((ClientRequest.Builder)ClientRequest.create().accept(new String[]{"application/x-gedcomx-v1+json"})).build(discoveryUri, method);
        return this.newCollectionState(request, client.handle(request), null);
    }

    public PersonState newPersonState(URI discoveryUri) {
        return this.newPersonState(discoveryUri, this.loadDefaultClient());
    }

    public PersonState newPersonState(URI discoveryUri, Client client) {
        return this.newPersonState(discoveryUri, client, "GET");
    }

    public PersonState newPersonState(URI discoveryUri, Client client, String method) {
        ClientRequest request = ((ClientRequest.Builder)ClientRequest.create().accept(new String[]{"application/x-gedcomx-v1+json"})).build(discoveryUri, method);
        return this.newPersonState(request, client.handle(request), null);
    }

    public RecordState newRecordState(URI discoveryUri) {
        return this.newRecordState(discoveryUri, this.loadDefaultClient());
    }

    public RecordState newRecordState(URI discoveryUri, Client client) {
        return this.newRecordState(discoveryUri, client, "GET");
    }

    public RecordState newRecordState(URI discoveryUri, Client client, String method) {
        ClientRequest request = ((ClientRequest.Builder)ClientRequest.create().accept(new String[]{"application/x-gedcomx-v1+json"})).build(discoveryUri, method);
        return this.newRecordState(request, client.handle(request), null);
    }

    protected Client loadDefaultClient() {
        Client client = new Client((ClientHandler)new URLConnectionClientHandler(), (ClientConfig)new DefaultClientConfig(new Class[]{GedcomJsonProvider.class, GedcomxXmlProvider.class, GedcomxAtomJsonProvider.class, JacksonJsonProvider.class}));
        if (Boolean.valueOf(System.getProperty(ENABLE_JERSEY_LOGGING_ENV_NAME)).booleanValue()) {
            client.addFilter((ClientFilter)new LoggingFilter());
        }
        return client;
    }

    protected AgentState newAgentState(ClientRequest request, ClientResponse response, String accessToken) {
        return new AgentState(request, response, accessToken, this);
    }

    protected AncestryResultsState newAncestryResultsState(ClientRequest request, ClientResponse response, String accessToken) {
        return new AncestryResultsState(request, response, accessToken, this);
    }

    protected CollectionsState newCollectionsState(ClientRequest request, ClientResponse response, String accessToken) {
        return new CollectionsState(request, response, accessToken, this);
    }

    protected CollectionState newCollectionState(ClientRequest request, ClientResponse response, String accessToken) {
        return new CollectionState(request, response, accessToken, this);
    }

    protected DescendancyResultsState newDescendancyResultsState(ClientRequest request, ClientResponse response, String accessToken) {
        return new DescendancyResultsState(request, response, accessToken, this);
    }

    protected PersonChildrenState newPersonChildrenState(ClientRequest request, ClientResponse response, String accessToken) {
        return new PersonChildrenState(request, response, accessToken, this);
    }

    protected PersonParentsState newPersonParentsState(ClientRequest request, ClientResponse response, String accessToken) {
        return new PersonParentsState(request, response, accessToken, this);
    }

    protected PersonSearchResultsState newPersonSearchResultsState(ClientRequest request, ClientResponse response, String accessToken) {
        return new PersonSearchResultsState(request, response, accessToken, this);
    }

    protected PlaceDescriptionState newPlaceDescriptionState(ClientRequest request, ClientResponse response, String accessToken) {
        return new PlaceDescriptionState(request, response, accessToken, this);
    }

    protected PlaceDescriptionsState newPlaceDescriptionsState(ClientRequest request, ClientResponse response, String accessToken) {
        return new PlaceDescriptionsState(request, response, accessToken, this);
    }

    public VocabElementState newVocabElementState(ClientRequest request, ClientResponse response, String accessToken) {
        return new VocabElementState(request, response, accessToken, this);
    }

    public VocabElementListState newVocabElementListState(ClientRequest request, ClientResponse response, String accessToken) {
        return new VocabElementListState(request, response, accessToken, this);
    }

    protected PersonSpousesState newPersonSpousesState(ClientRequest request, ClientResponse response, String accessToken) {
        return new PersonSpousesState(request, response, accessToken, this);
    }

    protected PersonsState newPersonsState(ClientRequest request, ClientResponse response, String accessToken) {
        return new PersonsState(request, response, accessToken, this);
    }

    protected PersonState newPersonState(ClientRequest request, ClientResponse response, String accessToken) {
        return new PersonState(request, response, accessToken, this);
    }

    protected RecordsState newRecordsState(ClientRequest request, ClientResponse response, String accessToken) {
        return new RecordsState(request, response, accessToken, this);
    }

    protected RecordState newRecordState(ClientRequest request, ClientResponse response, String accessToken) {
        return new RecordState(request, response, accessToken, this);
    }

    protected RelationshipsState newRelationshipsState(ClientRequest request, ClientResponse response, String accessToken) {
        return new RelationshipsState(request, response, accessToken, this);
    }

    protected RelationshipState newRelationshipState(ClientRequest request, ClientResponse response, String accessToken) {
        return new RelationshipState(request, response, accessToken, this);
    }

    protected SourceDescriptionsState newSourceDescriptionsState(ClientRequest request, ClientResponse response, String accessToken) {
        return new SourceDescriptionsState(request, response, accessToken, this);
    }

    protected SourceDescriptionState newSourceDescriptionState(ClientRequest request, ClientResponse response, String accessToken) {
        return new SourceDescriptionState(request, response, accessToken, this);
    }

    protected String buildErrorMessage(GedcomxApplicationState state) {
        StringBuilder builder = new StringBuilder("Unsuccessful ").append(state.request.getMethod()).append(" to ").append(state.getUri()).append(" (").append(state.response.getStatus()).append(")");
        List<HttpWarning> warnings = state.getWarnings();
        if (warnings != null && warnings.size() > 0) {
            for (HttpWarning warning : warnings) {
                builder.append("\nWarning: ").append(warning.getMessage());
            }
        }
        return builder.toString();
    }
}

