/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rs.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.core.header.LinkHeader;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.gedcomx.Gedcomx;
import org.gedcomx.common.Attributable;
import org.gedcomx.common.Attribution;
import org.gedcomx.common.ResourceReference;
import org.gedcomx.common.URI;
import org.gedcomx.links.Link;
import org.gedcomx.links.SupportsLinks;
import org.gedcomx.rs.client.AgentState;
import org.gedcomx.rs.client.GedcomxApplicationException;
import org.gedcomx.rs.client.StateFactory;
import org.gedcomx.rs.client.StateTransitionOption;
import org.gedcomx.rs.client.util.EmbeddedLinkLoader;
import org.gedcomx.rs.client.util.HttpWarning;
import org.gedcomx.source.SourceDescription;

public abstract class GedcomxApplicationState<E> {
    protected static final EmbeddedLinkLoader DEFAULT_EMBEDDED_LINK_LOADER = new EmbeddedLinkLoader();
    private static final String SDK_VERSION;
    protected final StateFactory stateFactory;
    protected final Map<String, Link> links;
    protected final Client client;
    protected final ClientRequest request;
    protected final ClientResponse response;
    protected final E entity;
    protected String accessToken;
    private ClientRequest lastEmbeddedRequest;
    private ClientResponse lastEmbeddedResponse;
    private final Set<String> embeddedLinksLoaded = new TreeSet<String>();

    protected GedcomxApplicationState(ClientRequest request, ClientResponse response, String accessToken, StateFactory stateFactory) {
        this.request = request;
        this.response = response;
        this.client = response.getClient();
        this.accessToken = accessToken;
        this.stateFactory = stateFactory;
        this.entity = this.loadEntityConditionally(this.response);
        List<Link> links = this.loadLinks(this.response, this.entity);
        this.links = new TreeMap<String, Link>();
        for (Link link : links) {
            this.links.put(link.getRel(), link);
        }
    }

    protected E loadEntityConditionally(ClientResponse response) {
        if (!"HEAD".equals(this.request.getMethod()) && !"OPTIONS".equals(this.request.getMethod()) && response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return this.loadEntity(response);
        }
        return null;
    }

    public GedcomxApplicationState inject(ClientRequest request) {
        return this.clone(request, this.invoke(request, new StateTransitionOption[0]));
    }

    protected abstract GedcomxApplicationState clone(ClientRequest var1, ClientResponse var2);

    protected abstract E loadEntity(ClientResponse var1);

    protected abstract SupportsLinks getMainDataElement();

    protected List<Link> loadLinks(ClientResponse response, E entity) {
        SupportsLinks mainElement;
        List linkHeaders;
        ArrayList<Link> links = new ArrayList<Link>();
        if (response.getLocation() != null) {
            links.add(new Link("self", new URI(response.getLocation().toString())));
        }
        if ((linkHeaders = (List)response.getHeaders().get((Object)"Link")) != null) {
            for (String header : linkHeaders) {
                LinkHeader lh = LinkHeader.valueOf((String)header);
                for (String rel : lh.getRel()) {
                    Link link = new Link(rel, lh.getUri() == null ? null : URI.create((String)lh.getUri().toString()));
                    link.setTemplate((String)lh.getParams().getFirst((Object)"template"));
                    link.setTitle((String)lh.getParams().getFirst((Object)"title"));
                    link.setAccept((String)lh.getParams().getFirst((Object)"accept"));
                    link.setAllow((String)lh.getParams().getFirst((Object)"allow"));
                    link.setHreflang((String)lh.getParams().getFirst((Object)"hreflang"));
                    link.setType((String)lh.getParams().getFirst((Object)"type"));
                    links.add(link);
                }
            }
        }
        if ((mainElement = this.getMainDataElement()) != null && mainElement.getLinks() != null) {
            links.addAll(mainElement.getLinks());
        }
        if (entity != mainElement && entity instanceof SupportsLinks && ((SupportsLinks)entity).getLinks() != null) {
            links.addAll(((SupportsLinks)entity).getLinks());
        }
        return links;
    }

    public Client getClient() {
        return this.client;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public boolean isAuthenticated() {
        return this.accessToken != null;
    }

    public ClientRequest getRequest() {
        return this.request.clone();
    }

    public ClientResponse getResponse() {
        return this.response;
    }

    public ClientRequest getLastEmbeddedRequest() {
        return this.lastEmbeddedRequest;
    }

    public ClientResponse getLastEmbeddedResponse() {
        return this.lastEmbeddedResponse;
    }

    public boolean isEmbeddedLinkLoaded(String rel) {
        return this.embeddedLinksLoaded.contains(rel);
    }

    public E getEntity() {
        return this.entity;
    }

    public SourceDescription getDescription() {
        Gedcomx gx;
        URI descriptionRef;
        if (this.entity instanceof Gedcomx && (descriptionRef = (gx = (Gedcomx)this.entity).getDescriptionRef()) != null && descriptionRef.toString().startsWith("#") && gx.getSourceDescriptions() != null) {
            String descriptionId = descriptionRef.toString().substring(1);
            for (SourceDescription description : gx.getSourceDescriptions()) {
                if (!descriptionId.equals(description.getId())) continue;
                return description;
            }
        }
        return null;
    }

    public java.net.URI getUri() {
        return this.request.getURI();
    }

    public boolean hasClientError() {
        return this.response.getStatus() >= 400 && this.response.getStatus() < 500;
    }

    public boolean hasServerError() {
        return this.response.getStatus() >= 500;
    }

    public boolean hasError() {
        return this.hasClientError() || this.hasServerError();
    }

    public boolean hasStatus(ClientResponse.Status status) {
        return status != null && status.equals((Object)this.response.getClientResponseStatus());
    }

    public EntityTag getETag() {
        return this.response.getEntityTag();
    }

    public Date getLastModified() {
        return this.response.getLastModified();
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.response.getHeaders();
    }

    public java.net.URI getSelfUri() {
        String selfRel = this.getSelfRel();
        Link link = null;
        if (selfRel != null) {
            link = this.getLink(selfRel);
        }
        Link link2 = link = link == null ? this.getLink("self") : link;
        java.net.URI self = link == null ? null : (link.getHref() == null ? null : link.getHref().toURI());
        return self == null ? this.getUri() : self;
    }

    public String getSelfRel() {
        return null;
    }

    public GedcomxApplicationState head(StateTransitionOption ... options) {
        ClientRequest.Builder builder = this.createAuthenticatedRequest();
        Object accept = this.request.getHeaders().getFirst((Object)"Accept");
        if (accept != null) {
            builder = (ClientRequest.Builder)builder.accept(new String[]{String.valueOf(accept)});
        }
        ClientRequest request = builder.build(this.getSelfUri(), "HEAD");
        return this.clone(request, this.invoke(request, options));
    }

    public GedcomxApplicationState get(StateTransitionOption ... options) {
        ClientRequest.Builder builder = this.createAuthenticatedRequest();
        Object accept = this.request.getHeaders().getFirst((Object)"Accept");
        if (accept != null) {
            builder = (ClientRequest.Builder)builder.accept(new String[]{String.valueOf(accept)});
        }
        ClientRequest request = builder.build(this.getSelfUri(), "GET");
        ClientResponse response = this.invoke(request, options);
        return this.clone(request, response);
    }

    public GedcomxApplicationState delete(StateTransitionOption ... options) {
        ClientRequest.Builder builder = this.createAuthenticatedRequest();
        Object accept = this.request.getHeaders().getFirst((Object)"Accept");
        if (accept != null) {
            builder = (ClientRequest.Builder)builder.accept(new String[]{String.valueOf(accept)});
        }
        ClientRequest request = builder.build(this.getSelfUri(), "DELETE");
        return this.clone(request, this.invoke(request, options));
    }

    public GedcomxApplicationState options(StateTransitionOption ... options) {
        ClientRequest.Builder builder = this.createAuthenticatedRequest();
        Object accept = this.request.getHeaders().getFirst((Object)"Accept");
        if (accept != null) {
            builder = (ClientRequest.Builder)builder.accept(new String[]{String.valueOf(accept)});
        }
        ClientRequest request = builder.build(this.getSelfUri(), "OPTIONS");
        return this.clone(request, this.invoke(request, options));
    }

    public GedcomxApplicationState put(E entity, StateTransitionOption ... options) {
        ClientRequest.Builder builder = this.createAuthenticatedRequest();
        Object accept = this.request.getHeaders().getFirst((Object)"Accept");
        Object contentType = this.request.getHeaders().getFirst((Object)"Content-Type");
        if (accept != null) {
            builder = (ClientRequest.Builder)builder.accept(new String[]{String.valueOf(accept)});
        }
        if (contentType != null) {
            builder = (ClientRequest.Builder)builder.type(String.valueOf(contentType));
        }
        ClientRequest request = ((ClientRequest.Builder)builder.entity(entity)).build(this.getSelfUri(), "PUT");
        return this.clone(request, this.invoke(request, options));
    }

    public GedcomxApplicationState post(E entity, StateTransitionOption ... options) {
        ClientRequest.Builder builder = this.createAuthenticatedRequest();
        Object accept = this.request.getHeaders().getFirst((Object)"Accept");
        Object contentType = this.request.getHeaders().getFirst((Object)"Content-Type");
        if (accept != null) {
            builder = (ClientRequest.Builder)builder.accept(new String[]{String.valueOf(accept)});
        }
        if (contentType != null) {
            builder = (ClientRequest.Builder)builder.type(String.valueOf(contentType));
        }
        ClientRequest request = ((ClientRequest.Builder)builder.entity(entity)).build(this.getSelfUri(), "POST");
        return this.clone(request, this.invoke(request, options));
    }

    public List<HttpWarning> getWarnings() {
        ArrayList<HttpWarning> warnings = new ArrayList<HttpWarning>();
        List warningValues = (List)this.response.getHeaders().get((Object)"Warning");
        if (warningValues != null) {
            for (String warningValue : warningValues) {
                warnings.add(HttpWarning.parse(warningValue));
            }
        }
        return warnings;
    }

    public Link getLink(String rel) {
        return this.links.get(rel);
    }

    public List<Link> getLinks() {
        return Arrays.asList(this.links.values().toArray(new Link[this.links.size()]));
    }

    public GedcomxApplicationState ifSuccessful() {
        if (this.hasError()) {
            throw new GedcomxApplicationException(this.buildFailureMessage(), this.response);
        }
        return this;
    }

    protected String buildFailureMessage() {
        Response.StatusType status = this.response.getStatusInfo();
        StringBuilder builder = new StringBuilder("Unsuccessful ").append(this.request.getMethod()).append(" to ").append(this.getUri()).append(" (").append(status.getStatusCode());
        if (status.getReasonPhrase() != null) {
            builder = builder.append(": ").append(status.getReasonPhrase());
        }
        builder = builder.append(")");
        List<HttpWarning> warnings = this.getWarnings();
        if (warnings != null && warnings.size() > 0) {
            for (HttpWarning warning : warnings) {
                builder.append("\nWarning: ").append(warning.getMessage());
            }
        }
        return builder.toString();
    }

    protected GedcomxApplicationState authenticateViaOAuth2Password(String username, String password, String clientId) {
        return this.authenticateViaOAuth2Password(username, password, clientId, null);
    }

    protected GedcomxApplicationState authenticateViaOAuth2Password(String username, String password, String clientId, String clientSecret) {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.putSingle((Object)"grant_type", (Object)"password");
        formData.putSingle((Object)"username", (Object)username);
        formData.putSingle((Object)"password", (Object)password);
        formData.putSingle((Object)"client_id", (Object)clientId);
        if (clientSecret != null) {
            formData.putSingle((Object)"client_secret", (Object)clientSecret);
        }
        return this.authenticateViaOAuth2((MultivaluedMap<String, String>)formData, new StateTransitionOption[0]);
    }

    protected GedcomxApplicationState authenticateViaOAuth2AuthCode(String authCode, String redirect, String clientId) {
        return this.authenticateViaOAuth2AuthCode(authCode, redirect, clientId, null);
    }

    protected GedcomxApplicationState authenticateViaOAuth2AuthCode(String authCode, String redirect, String clientId, String clientSecret) {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.putSingle((Object)"grant_type", (Object)"authorization_code");
        formData.putSingle((Object)"code", (Object)authCode);
        formData.putSingle((Object)"redirect_uri", (Object)redirect);
        formData.putSingle((Object)"client_id", (Object)clientId);
        if (clientSecret != null) {
            formData.putSingle((Object)"client_secret", (Object)clientSecret);
        }
        return this.authenticateViaOAuth2((MultivaluedMap<String, String>)formData, new StateTransitionOption[0]);
    }

    protected GedcomxApplicationState authenticateViaOAuth2ClientCredentials(String clientId, String clientSecret) {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.putSingle((Object)"grant_type", (Object)"client_credentials");
        formData.putSingle((Object)"client_id", (Object)clientId);
        if (clientSecret != null) {
            formData.putSingle((Object)"client_secret", (Object)clientSecret);
        }
        return this.authenticateViaOAuth2((MultivaluedMap<String, String>)formData, new StateTransitionOption[0]);
    }

    protected GedcomxApplicationState authenticateWithAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    protected GedcomxApplicationState authenticateViaOAuth2(MultivaluedMap<String, String> formData, StateTransitionOption ... options) {
        if (this.hasServerError()) {
            throw new GedcomxApplicationException(this.buildFailureMessage(), this.response);
        }
        Link tokenLink = this.links.get("http://oauth.net/core/2.0/endpoint/token");
        if (tokenLink == null || tokenLink.getHref() == null) {
            throw new GedcomxApplicationException(String.format("No OAuth2 token URI supplied for resource at %s.", this.getUri()));
        }
        java.net.URI tokenUri = tokenLink.getHref().toURI();
        ClientRequest request = ((ClientRequest.Builder)((ClientRequest.Builder)((ClientRequest.Builder)this.createRequest().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).entity(formData)).build(tokenUri, "POST");
        ClientResponse response = this.invoke(request, options);
        if (response.getStatus() >= 200 && response.getStatus() < 300) {
            ObjectNode accessToken = (ObjectNode)response.getEntity(ObjectNode.class);
            JsonNode access_token = accessToken.get("access_token");
            if (access_token == null) {
                access_token = accessToken.get("token");
            }
            if (access_token == null) {
                throw new GedcomxApplicationException("Illegal access token response: no access_token provided.", response);
            }
            return this.authenticateWithAccessToken(access_token.asText());
        }
        StringBuilder messageDetails = new StringBuilder();
        try {
            ObjectNode error = (ObjectNode)response.getEntity(ObjectNode.class);
            boolean hasErrorType = error.has("error");
            boolean hasErrorDescription = error.has("error_description");
            if (hasErrorType || hasErrorDescription) {
                messageDetails.append(" (");
                if (hasErrorType) {
                    messageDetails.append(error.get("error"));
                }
                if (hasErrorType && hasErrorDescription) {
                    messageDetails.append(": ");
                }
                if (hasErrorDescription) {
                    messageDetails.append(error.get("error_description"));
                }
                messageDetails.append(')');
            }
        }
        catch (Exception e) {
            messageDetails.append(" (no details available)");
        }
        throw new GedcomxApplicationException(String.format("Unable to obtain an access token%s.", messageDetails), response);
    }

    protected GedcomxApplicationState readPage(String rel, StateTransitionOption ... options) {
        Link link = this.getLink(rel);
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest.Builder builder = this.createAuthenticatedRequest();
        Object accept = this.request.getHeaders().getFirst((Object)"Accept");
        Object contentType = this.request.getHeaders().getFirst((Object)"Content-Type");
        if (accept != null) {
            builder = (ClientRequest.Builder)builder.accept(new String[]{String.valueOf(accept)});
        }
        if (contentType != null) {
            builder = (ClientRequest.Builder)builder.type(String.valueOf(contentType));
        }
        ClientRequest request = builder.build(link.getHref().toURI(), "GET");
        return this.clone(request, this.invoke(request, options));
    }

    protected GedcomxApplicationState readNextPage(StateTransitionOption ... options) {
        return this.readPage("next", options);
    }

    protected GedcomxApplicationState readPreviousPage(StateTransitionOption ... options) {
        return this.readPage("prev", options);
    }

    protected GedcomxApplicationState readFirstPage(StateTransitionOption ... options) {
        return this.readPage("first", options);
    }

    protected GedcomxApplicationState readLastPage(StateTransitionOption ... options) {
        return this.readPage("last", options);
    }

    protected ClientRequest.Builder createAuthenticatedFeedRequest() {
        return (ClientRequest.Builder)((ClientRequest.Builder)this.createAuthenticatedRequest().accept(new String[]{"application/x-gedcomx-atom+json"})).type("application/x-gedcomx-atom+json");
    }

    protected ClientRequest.Builder createAuthenticatedGedcomxRequest() {
        return (ClientRequest.Builder)((ClientRequest.Builder)this.createAuthenticatedRequest().accept(new String[]{"application/x-gedcomx-v1+json"})).type("application/x-gedcomx-v1+json");
    }

    protected ClientResponse invoke(ClientRequest request, StateTransitionOption ... options) {
        for (StateTransitionOption option : options) {
            option.apply(request);
        }
        return this.getClient().handle(request);
    }

    protected ClientRequest.Builder createRequest() {
        return (ClientRequest.Builder)ClientRequest.create().header("User-Agent", (Object)("gedcomx-java-sdk/" + SDK_VERSION));
    }

    protected ClientRequest.Builder createAuthenticatedRequest() {
        ClientRequest.Builder request = this.createRequest();
        if (this.accessToken != null) {
            request = (ClientRequest.Builder)request.header("Authorization", (Object)("Bearer " + this.accessToken));
        }
        return request;
    }

    protected void includeEmbeddedResources(Gedcomx entity, StateTransitionOption ... options) {
        this.embed(this.getEmbeddedLinkLoader().loadEmbeddedLinks(entity), entity, options);
    }

    protected void embed(List<Link> links, Gedcomx entity, StateTransitionOption ... options) {
        for (Link link : links) {
            this.embed(link, entity, options);
        }
    }

    protected EmbeddedLinkLoader getEmbeddedLinkLoader() {
        return DEFAULT_EMBEDDED_LINK_LOADER;
    }

    protected void embed(Link link, Gedcomx entity, StateTransitionOption ... options) {
        String rel = link.getRel();
        if (rel != null && this.isEmbeddedLinkLoaded(rel)) {
            return;
        }
        if (link.getHref() != null) {
            this.lastEmbeddedRequest = this.createRequestForEmbeddedResource(rel).build(link.getHref().toURI(), "GET");
            this.lastEmbeddedResponse = this.invoke(this.lastEmbeddedRequest, options);
            if (this.lastEmbeddedResponse.getClientResponseStatus() == ClientResponse.Status.OK) {
                entity.embed((Gedcomx)this.lastEmbeddedResponse.getEntity(Gedcomx.class));
                if (rel != null) {
                    this.embeddedLinksLoaded.add(rel);
                }
            } else if (this.lastEmbeddedResponse.getStatus() >= 500) {
                throw new GedcomxApplicationException(String.format("Unable to load embedded resources: server says \"%s\" at %s.", this.lastEmbeddedResponse.getStatus(), this.lastEmbeddedRequest.getURI()), this.lastEmbeddedResponse);
            }
        }
    }

    protected ClientRequest.Builder createRequestForEmbeddedResource(String rel) {
        return this.createAuthenticatedGedcomxRequest();
    }

    public AgentState readContributor(StateTransitionOption ... options) {
        SupportsLinks scope = this.getMainDataElement();
        if (scope instanceof Attributable) {
            return this.readContributor((Attributable)scope, options);
        }
        return null;
    }

    public AgentState readContributor(Attributable attributable, StateTransitionOption ... options) {
        Attribution attribution = attributable.getAttribution();
        if (attribution == null) {
            return null;
        }
        return this.readContributor(attribution.getContributor(), options);
    }

    public AgentState readContributor(ResourceReference contributor, StateTransitionOption ... options) {
        if (contributor == null || contributor.getResource() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(contributor.getResource().toURI(), "GET");
        return this.stateFactory.newAgentState(request, this.invoke(request, options), this.accessToken);
    }

    static {
        String localSdkVersion = null;
        String propertiesFile = "/META-INF/maven/org.gedcomx/gedcomx-rs-client/pom.properties";
        try (InputStream propertiesInputStream = ClassLoader.class.getResourceAsStream("/META-INF/maven/org.gedcomx/gedcomx-rs-client/pom.properties");){
            Properties properties = new Properties();
            properties.load(propertiesInputStream);
            localSdkVersion = properties.getProperty("version");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        SDK_VERSION = StringUtils.isBlank(localSdkVersion) ? "UNKNOWN" : localSdkVersion;
    }
}

