/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rs.client;

import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import java.util.List;
import org.gedcomx.Gedcomx;
import org.gedcomx.common.ResourceReference;
import org.gedcomx.conclusion.Person;
import org.gedcomx.conclusion.Relationship;
import org.gedcomx.links.Link;
import org.gedcomx.links.SupportsLinks;
import org.gedcomx.rs.client.GedcomxApplicationException;
import org.gedcomx.rs.client.GedcomxApplicationState;
import org.gedcomx.rs.client.PersonState;
import org.gedcomx.rs.client.RelationshipState;
import org.gedcomx.rs.client.StateFactory;
import org.gedcomx.rs.client.StateTransitionOption;
import org.gedcomx.types.GenderType;

public class PersonParentsState
extends GedcomxApplicationState<Gedcomx> {
    protected PersonParentsState(ClientRequest request, ClientResponse response, String accessToken, StateFactory stateFactory) {
        super(request, response, accessToken, stateFactory);
    }

    @Override
    protected PersonParentsState clone(ClientRequest request, ClientResponse response) {
        return new PersonParentsState(request, response, this.accessToken, this.stateFactory);
    }

    @Override
    public PersonParentsState ifSuccessful() {
        return (PersonParentsState)super.ifSuccessful();
    }

    @Override
    public PersonParentsState head(StateTransitionOption ... options) {
        return (PersonParentsState)super.head(options);
    }

    @Override
    public PersonParentsState options(StateTransitionOption ... options) {
        return (PersonParentsState)super.options(options);
    }

    @Override
    public PersonParentsState get(StateTransitionOption ... options) {
        return (PersonParentsState)super.get(options);
    }

    @Override
    public PersonParentsState delete(StateTransitionOption ... options) {
        return (PersonParentsState)super.delete(options);
    }

    public PersonParentsState put(Gedcomx e, StateTransitionOption ... options) {
        return (PersonParentsState)super.put(e, options);
    }

    public PersonParentsState post(Gedcomx entity, StateTransitionOption ... options) {
        return (PersonParentsState)super.post(entity, options);
    }

    @Override
    protected Gedcomx loadEntity(ClientResponse response) {
        return (Gedcomx)response.getEntity(Gedcomx.class);
    }

    @Override
    protected SupportsLinks getMainDataElement() {
        return (SupportsLinks)this.getEntity();
    }

    public List<Person> getPersons() {
        return this.entity == null ? null : ((Gedcomx)this.entity).getPersons();
    }

    public List<Relationship> getRelationships() {
        return this.entity == null ? null : ((Gedcomx)this.entity).getRelationships();
    }

    public Relationship findRelationshipTo(Person parent) {
        List<Relationship> relationships = this.getRelationships();
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                String reference;
                ResourceReference parentReference = relationship.getPerson1();
                if (parentReference == null || !(reference = parentReference.getResource().toString()).equals("#" + parent.getId())) continue;
                return relationship;
            }
        }
        return null;
    }

    public PersonState readPerson(StateTransitionOption ... options) {
        Link link = this.getLink("person");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonState readParent(Person person, StateTransitionOption ... options) {
        Link link = person.getLink("person");
        Link link2 = link = link == null ? person.getLink("self") : link;
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonState readMaleParent() {
        return this.readFather();
    }

    private PersonState readFather() {
        PersonState father = null;
        List<Person> listOfParents = this.getPersons();
        if (null != listOfParents) {
            for (Person parent : listOfParents) {
                if (!GenderType.Male.equals((Object)parent.getGender().getKnownType())) continue;
                father = this.readParent(parent, new StateTransitionOption[0]);
                break;
            }
        }
        return father;
    }

    public PersonState readFemaleParent() {
        return this.readMother();
    }

    private PersonState readMother() {
        PersonState mother = null;
        List<Person> listOfParents = this.getPersons();
        if (null != listOfParents) {
            for (Person parent : listOfParents) {
                if (!GenderType.Female.equals((Object)parent.getGender().getKnownType())) continue;
                mother = this.readParent(parent, new StateTransitionOption[0]);
                break;
            }
        }
        return mother;
    }

    public RelationshipState readRelationship(Relationship relationship, StateTransitionOption ... options) {
        Link link = relationship.getLink("relationship");
        Link link2 = link = link == null ? relationship.getLink("self") : link;
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newRelationshipState(request, this.invoke(request, options), this.accessToken);
    }

    public RelationshipState removeRelationship(Relationship relationship, StateTransitionOption ... options) {
        Link link = relationship.getLink("relationship");
        Link link2 = link = link == null ? relationship.getLink("self") : link;
        if (link == null || link.getHref() == null) {
            throw new GedcomxApplicationException("Unable to remove relationship: missing link.");
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "DELETE");
        return this.stateFactory.newRelationshipState(request, this.invoke(request, options), this.accessToken);
    }

    public RelationshipState removeRelationshipTo(Person parent, StateTransitionOption ... options) {
        Relationship relationship = this.findRelationshipTo(parent);
        if (relationship == null) {
            throw new GedcomxApplicationException("Unable to remove relationship: not found.");
        }
        Link link = relationship.getLink("relationship");
        Link link2 = link = link == null ? relationship.getLink("self") : link;
        if (link == null || link.getHref() == null) {
            throw new GedcomxApplicationException("Unable to remove relationship: missing link.");
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "DELETE");
        return this.stateFactory.newRelationshipState(request, this.invoke(request, options), this.accessToken);
    }
}

