/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rs.client;

import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import javax.ws.rs.core.UriBuilder;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Seq;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.gedcomx.common.URI;
import org.gedcomx.links.SupportsLinks;
import org.gedcomx.rs.client.GedcomxApplicationState;
import org.gedcomx.rs.client.StateFactory;
import org.gedcomx.rs.client.StateTransitionOption;
import org.gedcomx.vocab.VocabElement;
import org.gedcomx.vocab.VocabElementList;

public class VocabElementListState
extends GedcomxApplicationState<Model> {
    private Resource resourceDescribingList;

    protected VocabElementListState(ClientRequest request, ClientResponse response, String accessToken, StateFactory stateFactory) {
        super(request, response, accessToken, stateFactory);
    }

    @Override
    public String getSelfRel() {
        return "description";
    }

    @Override
    protected VocabElementListState clone(ClientRequest request, ClientResponse response) {
        return new VocabElementListState(request, response, this.accessToken, this.stateFactory);
    }

    @Override
    public VocabElementListState ifSuccessful() {
        return (VocabElementListState)super.ifSuccessful();
    }

    @Override
    public VocabElementListState head(StateTransitionOption ... options) {
        return (VocabElementListState)super.head(options);
    }

    @Override
    public VocabElementListState options(StateTransitionOption ... options) {
        return (VocabElementListState)super.options(options);
    }

    @Override
    public VocabElementListState get(StateTransitionOption ... options) {
        return (VocabElementListState)super.get(options);
    }

    @Override
    public VocabElementListState delete(StateTransitionOption ... options) {
        return (VocabElementListState)super.delete(options);
    }

    public VocabElementListState put(Model e, StateTransitionOption ... options) {
        return (VocabElementListState)super.put(e, options);
    }

    public VocabElementListState post(Model entity, StateTransitionOption ... options) {
        return (VocabElementListState)super.post(entity, options);
    }

    public VocabElementList getVocabElementList() {
        if (this.resourceDescribingList == null) {
            return null;
        }
        Model model = this.resourceDescribingList.getModel();
        VocabElementList vocabElementList = new VocabElementList();
        Property identifierProperty = model.createProperty("http://purl.org/dc/terms/", "identifier");
        if (this.resourceDescribingList.hasProperty(identifierProperty)) {
            vocabElementList.setId(this.resourceDescribingList.getRequiredProperty(model.createProperty("http://purl.org/dc/terms/", "identifier")).getString());
        }
        vocabElementList.setUri(URI.create((String)this.resourceDescribingList.getURI()));
        vocabElementList.setTitle(this.resourceDescribingList.getRequiredProperty(model.createProperty("http://purl.org/dc/terms/", "title")).getString());
        vocabElementList.setDescription(this.resourceDescribingList.getRequiredProperty(model.createProperty("http://purl.org/dc/terms/", "description")).getString());
        Seq seq = (Seq)this.resourceDescribingList.as(Seq.class);
        for (int i = 0; i < seq.size(); ++i) {
            vocabElementList.addElement(this.mapToVocabElement(seq.getResource(i + 1)));
        }
        return vocabElementList;
    }

    @Override
    protected Model loadEntity(ClientResponse response) {
        Model model = ModelFactory.createDefaultModel();
        model.read(response.getEntityInputStream(), null, "JSONLD");
        this.resourceDescribingList = model.getResource(UriBuilder.fromUri((java.net.URI)this.request.getURI()).replaceQueryParam("flag", (Object[])null).build(new Object[0]).toString());
        return model;
    }

    @Override
    protected SupportsLinks getMainDataElement() {
        return null;
    }

    private VocabElement mapToVocabElement(Resource resourceDescribingElement) {
        VocabElement vocabElement = new VocabElement();
        Model model = resourceDescribingElement.getModel();
        vocabElement.setId(resourceDescribingElement.getRequiredProperty(model.createProperty("http://purl.org/dc/terms/", "identifier")).getString());
        vocabElement.setUri(URI.create((String)resourceDescribingElement.getURI()));
        Property property = model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "subClassOf");
        if (resourceDescribingElement.hasProperty(property)) {
            vocabElement.setSubclass(URI.create((String)resourceDescribingElement.getRequiredProperty(model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "subClassOf")).getResource().getURI()));
        }
        if (resourceDescribingElement.hasProperty(property = model.createProperty("http://purl.org/dc/terms/", "type"))) {
            vocabElement.setType(URI.create((String)resourceDescribingElement.getRequiredProperty(model.createProperty("http://purl.org/dc/terms/", "type")).getResource().getURI()));
        }
        StmtIterator labels = resourceDescribingElement.listProperties(model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "label"));
        while (labels.hasNext()) {
            Statement next = (Statement)labels.next();
            vocabElement.addLabel(next.getString(), next.getLanguage().toLowerCase());
        }
        StmtIterator descriptions = resourceDescribingElement.listProperties(model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "comment"));
        while (descriptions.hasNext()) {
            Statement next = (Statement)descriptions.next();
            vocabElement.addDescription(next.getString(), next.getLanguage().toLowerCase());
        }
        return vocabElement;
    }
}

