/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rs.client;

import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.gedcomx.links.SupportsLinks;
import org.gedcomx.rs.client.GedcomxApplicationState;
import org.gedcomx.rs.client.StateFactory;
import org.gedcomx.rs.client.StateTransitionOption;
import org.gedcomx.vocab.VocabElement;

public class VocabElementState
extends GedcomxApplicationState<Model> {
    private Resource resourceDescribingElement;
    private Model model;

    protected VocabElementState(ClientRequest request, ClientResponse response, String accessToken, StateFactory stateFactory) {
        super(request, response, accessToken, stateFactory);
    }

    @Override
    public String getSelfRel() {
        return "description";
    }

    @Override
    protected VocabElementState clone(ClientRequest request, ClientResponse response) {
        return new VocabElementState(request, response, this.accessToken, this.stateFactory);
    }

    @Override
    public VocabElementState ifSuccessful() {
        return (VocabElementState)super.ifSuccessful();
    }

    @Override
    public VocabElementState head(StateTransitionOption ... options) {
        return (VocabElementState)super.head(options);
    }

    @Override
    public VocabElementState options(StateTransitionOption ... options) {
        return (VocabElementState)super.options(options);
    }

    @Override
    public VocabElementState get(StateTransitionOption ... options) {
        return (VocabElementState)super.get(options);
    }

    @Override
    public VocabElementState delete(StateTransitionOption ... options) {
        return (VocabElementState)super.delete(options);
    }

    public VocabElementState put(Model e, StateTransitionOption ... options) {
        return (VocabElementState)super.put(e, options);
    }

    public VocabElementState post(Model entity, StateTransitionOption ... options) {
        return (VocabElementState)super.post(entity, options);
    }

    @Override
    protected Model loadEntity(ClientResponse response) {
        this.model = ModelFactory.createDefaultModel();
        this.model.read(response.getEntityInputStream(), null, "JSONLD");
        this.resourceDescribingElement = this.model.getResource(UriBuilder.fromUri((URI)this.request.getURI()).replaceQueryParam("flag", (Object[])null).build(new Object[0]).toString());
        return this.model;
    }

    public VocabElement getVocabElement() {
        VocabElement vocabElement = new VocabElement();
        Model model = this.resourceDescribingElement.getModel();
        vocabElement.setId(this.resourceDescribingElement.getRequiredProperty(model.createProperty("http://purl.org/dc/terms/", "identifier")).getString());
        vocabElement.setUri(org.gedcomx.common.URI.create((String)this.resourceDescribingElement.getURI()));
        Property property = model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "subClassOf");
        if (this.resourceDescribingElement.hasProperty(property)) {
            vocabElement.setSubclass(org.gedcomx.common.URI.create((String)this.resourceDescribingElement.getRequiredProperty(model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "subClassOf")).getResource().getURI()));
        }
        if (this.resourceDescribingElement.hasProperty(property = model.createProperty("http://purl.org/dc/terms/", "type"))) {
            vocabElement.setType(org.gedcomx.common.URI.create((String)this.resourceDescribingElement.getRequiredProperty(model.createProperty("http://purl.org/dc/terms/", "type")).getResource().getURI()));
        }
        StmtIterator labels = this.resourceDescribingElement.listProperties(model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "label"));
        while (labels.hasNext()) {
            Statement next = (Statement)labels.next();
            vocabElement.addLabel(next.getString(), next.getLanguage().toLowerCase());
        }
        StmtIterator descriptions = this.resourceDescribingElement.listProperties(model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "comment"));
        while (descriptions.hasNext()) {
            Statement next = (Statement)descriptions.next();
            vocabElement.addDescription(next.getString(), next.getLanguage().toLowerCase());
        }
        return vocabElement;
    }

    @Override
    protected SupportsLinks getMainDataElement() {
        return null;
    }

    private Resource getResourceDescribingElement() {
        if (null == this.resourceDescribingElement) {
            this.resourceDescribingElement = this.model.getResource(this.request.getURI().toString());
        }
        return this.resourceDescribingElement;
    }
}

