/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rs.client.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.gedcomx.Gedcomx;
import org.gedcomx.conclusion.Person;
import org.gedcomx.conclusion.Relationship;
import org.gedcomx.links.Link;

public class EmbeddedLinkLoader {
    public static final Set<String> DEFAULT_EMBEDDED_LINK_RELS = Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList("child-relationships", "conclusions", "evidence-references", "media-references", "notes", "parent-relationships", "source-references", "spouse-relationships")));

    protected Set<String> getEmbeddedLinkRels() {
        return DEFAULT_EMBEDDED_LINK_RELS;
    }

    public List<Link> loadEmbeddedLinks(Gedcomx entity) {
        List relationships;
        ArrayList<Link> embeddedLinks = new ArrayList<Link>();
        Set<String> embeddedRels = this.getEmbeddedLinkRels();
        List persons = entity.getPersons();
        if (persons != null) {
            for (Person person : persons) {
                for (String embeddedRel : embeddedRels) {
                    Link link = person.getLink(embeddedRel);
                    if (link == null) continue;
                    embeddedLinks.add(link);
                }
            }
        }
        if ((relationships = entity.getRelationships()) != null) {
            for (Relationship relationship : relationships) {
                for (String embeddedRel : embeddedRels) {
                    Link link = relationship.getLink(embeddedRel);
                    if (link == null) continue;
                    embeddedLinks.add(link);
                }
            }
        }
        return embeddedLinks;
    }
}

