/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rs.client;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.activation.DataSource;
import javax.ws.rs.core.MultivaluedMap;
import org.gedcomx.Gedcomx;
import org.gedcomx.common.EvidenceReference;
import org.gedcomx.common.Note;
import org.gedcomx.common.ResourceReference;
import org.gedcomx.common.URI;
import org.gedcomx.conclusion.Conclusion;
import org.gedcomx.conclusion.DisplayProperties;
import org.gedcomx.conclusion.Fact;
import org.gedcomx.conclusion.Gender;
import org.gedcomx.conclusion.Name;
import org.gedcomx.conclusion.Person;
import org.gedcomx.conclusion.Relationship;
import org.gedcomx.links.Link;
import org.gedcomx.links.SupportsLinks;
import org.gedcomx.rs.client.AncestryResultsState;
import org.gedcomx.rs.client.CollectionState;
import org.gedcomx.rs.client.DescendancyResultsState;
import org.gedcomx.rs.client.GedcomxApplicationException;
import org.gedcomx.rs.client.GedcomxApplicationState;
import org.gedcomx.rs.client.PersonChildrenState;
import org.gedcomx.rs.client.PersonParentsState;
import org.gedcomx.rs.client.PersonSpousesState;
import org.gedcomx.rs.client.RecordState;
import org.gedcomx.rs.client.RelationshipState;
import org.gedcomx.rs.client.SourceDescriptionState;
import org.gedcomx.rs.client.SourceDescriptionsState;
import org.gedcomx.rs.client.StateFactory;
import org.gedcomx.rs.client.StateTransitionOption;
import org.gedcomx.source.SourceDescription;
import org.gedcomx.source.SourceReference;
import org.gedcomx.types.RelationshipType;

public class PersonState
extends GedcomxApplicationState<Gedcomx> {
    public PersonState(java.net.URI uri) {
        this(uri, new StateFactory());
    }

    private PersonState(java.net.URI uri, StateFactory stateFactory) {
        this(uri, stateFactory.loadDefaultClient(), stateFactory);
    }

    private PersonState(java.net.URI uri, Client client, StateFactory stateFactory) {
        this(((ClientRequest.Builder)ClientRequest.create().accept(new String[]{"application/x-gedcomx-v1+json"})).build(uri, "GET"), client, stateFactory);
    }

    private PersonState(ClientRequest request, Client client, StateFactory stateFactory) {
        this(request, client.handle(request), null, stateFactory);
    }

    protected PersonState(ClientRequest request, ClientResponse response, String accessToken, StateFactory stateFactory) {
        super(request, response, accessToken, stateFactory);
    }

    @Override
    public String getSelfRel() {
        return "person";
    }

    @Override
    protected PersonState clone(ClientRequest request, ClientResponse response) {
        return new PersonState(request, response, this.accessToken, this.stateFactory);
    }

    @Override
    public PersonState ifSuccessful() {
        return (PersonState)super.ifSuccessful();
    }

    @Override
    public PersonState head(StateTransitionOption ... options) {
        return (PersonState)super.head(options);
    }

    @Override
    public PersonState get(StateTransitionOption ... options) {
        return (PersonState)super.get(options);
    }

    @Override
    public PersonState delete(StateTransitionOption ... options) {
        return (PersonState)super.delete(options);
    }

    public PersonState put(Gedcomx e, StateTransitionOption ... options) {
        return (PersonState)super.put(e, options);
    }

    public PersonState post(Gedcomx entity, StateTransitionOption ... options) {
        return (PersonState)super.post(entity, options);
    }

    @Override
    public PersonState options(StateTransitionOption ... options) {
        return (PersonState)super.options(options);
    }

    @Override
    protected Gedcomx loadEntity(ClientResponse response) {
        return (Gedcomx)response.getEntity(Gedcomx.class);
    }

    @Override
    protected SupportsLinks getMainDataElement() {
        return this.getPerson();
    }

    public Person getPerson() {
        return this.getEntity() == null ? null : (((Gedcomx)this.getEntity()).getPersons() == null ? null : (((Gedcomx)this.getEntity()).getPersons().isEmpty() ? null : (Person)((Gedcomx)this.getEntity()).getPersons().get(0)));
    }

    public List<Relationship> getRelationships() {
        return this.getEntity() == null ? null : ((Gedcomx)this.getEntity()).getRelationships();
    }

    public List<Relationship> getSpouseRelationships() {
        ArrayList<Relationship> relationships = this.getRelationships();
        ArrayList<Relationship> arrayList = relationships = relationships == null ? null : new ArrayList<Relationship>(relationships);
        if (relationships != null) {
            Iterator it = relationships.iterator();
            while (it.hasNext()) {
                if (((Relationship)it.next()).getKnownType() == RelationshipType.Couple) continue;
                it.remove();
            }
        }
        return relationships;
    }

    public List<Relationship> getChildRelationships() {
        ArrayList<Relationship> relationships = this.getRelationships();
        ArrayList<Relationship> arrayList = relationships = relationships == null ? null : new ArrayList<Relationship>(relationships);
        if (relationships != null) {
            Iterator it = relationships.iterator();
            while (it.hasNext()) {
                Relationship relationship = (Relationship)it.next();
                if (relationship.getKnownType() == RelationshipType.ParentChild && this.refersToMe(relationship.getPerson1())) continue;
                it.remove();
            }
        }
        return relationships;
    }

    public List<Relationship> getParentRelationships() {
        ArrayList<Relationship> relationships = this.getRelationships();
        ArrayList<Relationship> arrayList = relationships = relationships == null ? null : new ArrayList<Relationship>(relationships);
        if (relationships != null) {
            Iterator it = relationships.iterator();
            while (it.hasNext()) {
                Relationship relationship = (Relationship)it.next();
                if (relationship.getKnownType() == RelationshipType.ParentChild && this.refersToMe(relationship.getPerson2())) continue;
                it.remove();
            }
        }
        return relationships;
    }

    protected boolean refersToMe(ResourceReference ref) {
        return ref != null && ref.getResource() != null && ref.getResource().toString().equals("#" + this.getLocalSelfId());
    }

    public DisplayProperties getDisplayProperties() {
        Person person = this.getPerson();
        return person == null ? null : person.getDisplayExtension();
    }

    public Conclusion getConclusion() {
        return this.getName() != null ? this.getName() : (this.getGender() != null ? this.getGender() : (this.getFact() != null ? this.getFact() : null));
    }

    public Name getName() {
        Person person = this.getPerson();
        return person == null ? null : (person.getNames() == null ? null : (person.getNames().isEmpty() ? null : (Name)person.getNames().get(0)));
    }

    public Gender getGender() {
        Person person = this.getPerson();
        return person == null ? null : person.getGender();
    }

    public Fact getFact() {
        Person person = this.getPerson();
        return person == null ? null : (person.getFacts() == null ? null : (person.getFacts().isEmpty() ? null : (Fact)person.getFacts().get(0)));
    }

    public Note getNote() {
        Person person = this.getPerson();
        return person == null ? null : (person.getNotes() == null ? null : (person.getNotes().isEmpty() ? null : (Note)person.getNotes().get(0)));
    }

    public SourceReference getSourceReference() {
        Person person = this.getPerson();
        return person == null ? null : (person.getSources() == null ? null : (person.getSources().isEmpty() ? null : (SourceReference)person.getSources().get(0)));
    }

    public EvidenceReference getEvidenceReference() {
        Person person = this.getPerson();
        return person == null ? null : (person.getEvidence() == null ? null : (person.getEvidence().isEmpty() ? null : (EvidenceReference)person.getEvidence().get(0)));
    }

    public EvidenceReference getPersonaReference() {
        return this.getEvidenceReference();
    }

    public SourceReference getMediaReference() {
        Person person = this.getPerson();
        return person == null ? null : (person.getMedia() == null ? null : (person.getMedia().isEmpty() ? null : (SourceReference)person.getMedia().get(0)));
    }

    @Override
    public PersonState authenticateViaOAuth2Password(String username, String password, String clientId) {
        return (PersonState)super.authenticateViaOAuth2Password(username, password, clientId);
    }

    @Override
    public PersonState authenticateViaOAuth2Password(String username, String password, String clientId, String clientSecret) {
        return (PersonState)super.authenticateViaOAuth2Password(username, password, clientId, clientSecret);
    }

    @Override
    public PersonState authenticateViaOAuth2AuthCode(String authCode, String redirect, String clientId) {
        return (PersonState)super.authenticateViaOAuth2AuthCode(authCode, redirect, clientId);
    }

    @Override
    public PersonState authenticateViaOAuth2AuthCode(String authCode, String redirect, String clientId, String clientSecret) {
        return (PersonState)super.authenticateViaOAuth2AuthCode(authCode, redirect, clientId, clientSecret);
    }

    @Override
    public PersonState authenticateViaOAuth2ClientCredentials(String clientId, String clientSecret) {
        return (PersonState)super.authenticateViaOAuth2ClientCredentials(clientId, clientSecret);
    }

    @Override
    public PersonState authenticateWithAccessToken(String accessToken) {
        return (PersonState)super.authenticateWithAccessToken(accessToken);
    }

    @Override
    public PersonState authenticateViaOAuth2(MultivaluedMap<String, String> formData, StateTransitionOption ... options) {
        return (PersonState)super.authenticateViaOAuth2(formData, options);
    }

    public CollectionState readCollection(StateTransitionOption ... options) {
        Link link = this.getLink("collection");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newCollectionState(request, this.invoke(request, options), this.accessToken);
    }

    public AncestryResultsState readAncestry(StateTransitionOption ... options) {
        Link link = this.getLink("ancestry");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newAncestryResultsState(request, this.invoke(request, options), this.accessToken);
    }

    public DescendancyResultsState readDescendancy(StateTransitionOption ... options) {
        Link link = this.getLink("descendancy");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newDescendancyResultsState(request, this.invoke(request, options), this.accessToken);
    }

    public SourceDescriptionsState readSourceDescriptions(StateTransitionOption ... options) {
        Link link = this.getLink("source-descriptions");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newSourceDescriptionsState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonState loadEmbeddedResources(StateTransitionOption ... options) {
        this.includeEmbeddedResources((Gedcomx)this.entity, options);
        return this;
    }

    public PersonState loadEmbeddedResources(String[] rels, StateTransitionOption ... options) {
        for (String rel : rels) {
            Link link = this.getLink(rel);
            if (this.entity == null || link == null || link.getHref() == null) continue;
            this.embed(link, (Gedcomx)this.entity, options);
        }
        return this;
    }

    public PersonState loadConclusions(StateTransitionOption ... options) {
        return this.loadEmbeddedResources(new String[]{"conclusions"}, options);
    }

    public PersonState loadSourceReferences(StateTransitionOption ... options) {
        return this.loadEmbeddedResources(new String[]{"source-references"}, options);
    }

    public PersonState loadMediaReferences(StateTransitionOption ... options) {
        return this.loadEmbeddedResources(new String[]{"media-references"}, options);
    }

    public PersonState loadEvidenceReferences(StateTransitionOption ... options) {
        return this.loadEmbeddedResources(new String[]{"evidence-references"}, options);
    }

    public PersonState loadPersonaReferences(StateTransitionOption ... options) {
        return this.loadEvidenceReferences(options);
    }

    public PersonState loadNotes(StateTransitionOption ... options) {
        return this.loadEmbeddedResources(new String[]{"notes"}, options);
    }

    public PersonState loadParentRelationships(StateTransitionOption ... options) {
        return this.loadEmbeddedResources(new String[]{"parent-relationships"}, options);
    }

    public PersonState loadSpouseRelationships(StateTransitionOption ... options) {
        return this.loadEmbeddedResources(new String[]{"spouse-relationships"}, options);
    }

    public PersonState loadChildRelationships(StateTransitionOption ... options) {
        return this.loadEmbeddedResources(new String[]{"child-relationships"}, options);
    }

    protected Person createEmptySelf() {
        Person person = new Person();
        person.setId(this.getLocalSelfId());
        return person;
    }

    protected String getLocalSelfId() {
        Person me = this.getPerson();
        return me == null ? null : me.getId();
    }

    public PersonState update(Person person, StateTransitionOption ... options) {
        if (this.getLink("conclusions") != null && (person.getNames() != null || person.getFacts() != null || person.getGender() != null)) {
            this.updateConclusions(person, new StateTransitionOption[0]);
        }
        if (this.getLink("evidence-references") != null && person.getEvidence() != null) {
            this.updateEvidenceReferences(person, new StateTransitionOption[0]);
        }
        if (this.getLink("media-references") != null && person.getMedia() != null) {
            this.updateMediaReferences(person, new StateTransitionOption[0]);
        }
        if (this.getLink("source-references") != null && person.getSources() != null) {
            this.updateSourceReferences(person, new StateTransitionOption[0]);
        }
        if (this.getLink("notes") != null && person.getNotes() != null) {
            this.updateNotes(person, new StateTransitionOption[0]);
        }
        Gedcomx gx = new Gedcomx();
        gx.setPersons(Arrays.asList(person));
        ClientRequest request = ((ClientRequest.Builder)this.createAuthenticatedGedcomxRequest().entity((Object)gx)).build(this.getSelfUri(), "POST");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonState addGender(Gender gender, StateTransitionOption ... options) {
        Person person = this.createEmptySelf();
        person.setGender(gender);
        return this.updateConclusions(person, options);
    }

    public PersonState addName(Name name, StateTransitionOption ... options) {
        return this.addNames(new Name[]{name}, options);
    }

    public PersonState addNames(Name[] names, StateTransitionOption ... options) {
        Person person = this.createEmptySelf();
        person.setNames(Arrays.asList(names));
        return this.updateConclusions(person, options);
    }

    public PersonState addFact(Fact fact, StateTransitionOption ... options) {
        return this.addFacts(new Fact[]{fact}, options);
    }

    public PersonState addFacts(Fact[] facts, StateTransitionOption ... options) {
        Person person = this.createEmptySelf();
        person.setFacts(Arrays.asList(facts));
        return this.updateConclusions(person, options);
    }

    public PersonState updateGender(Gender gender, StateTransitionOption ... options) {
        Person person = this.createEmptySelf();
        person.setGender(gender);
        return this.updateConclusions(person, options);
    }

    public PersonState updateName(Name name, StateTransitionOption ... options) {
        return this.updateNames(new Name[]{name}, options);
    }

    public PersonState updateNames(Name[] names, StateTransitionOption ... options) {
        Person person = this.createEmptySelf();
        person.setNames(Arrays.asList(names));
        return this.updateConclusions(person, new StateTransitionOption[0]);
    }

    public PersonState updateFact(Fact fact, StateTransitionOption ... options) {
        return this.updateFacts(new Fact[]{fact}, options);
    }

    public PersonState updateFacts(Fact[] facts, StateTransitionOption ... options) {
        Person person = this.createEmptySelf();
        person.setFacts(Arrays.asList(facts));
        return this.updateConclusions(person, options);
    }

    public PersonState updateConclusions(Person person, StateTransitionOption ... options) {
        Gedcomx gx = new Gedcomx();
        gx.setPersons(Arrays.asList(person));
        return this.updateConclusions(gx, options);
    }

    public PersonState updateConclusions(Gedcomx gx, StateTransitionOption ... options) {
        java.net.URI target = this.getSelfUri();
        Link conclusionsLink = this.getLink("conclusions");
        if (conclusionsLink != null && conclusionsLink.getHref() != null) {
            target = conclusionsLink.getHref().toURI();
        }
        ClientRequest request = ((ClientRequest.Builder)this.createAuthenticatedGedcomxRequest().entity((Object)gx)).build(target, "POST");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonState deleteName(Name name, StateTransitionOption ... options) {
        return this.doDeleteConclusion((Conclusion)name, options);
    }

    public PersonState deleteGender(Gender gender, StateTransitionOption ... options) {
        return this.doDeleteConclusion((Conclusion)gender, options);
    }

    public PersonState deleteFact(Fact fact, StateTransitionOption ... options) {
        return this.doDeleteConclusion((Conclusion)fact, options);
    }

    protected PersonState doDeleteConclusion(Conclusion conclusion, StateTransitionOption ... options) {
        Link link = conclusion.getLink("conclusion");
        Link link2 = link = link == null ? conclusion.getLink("self") : link;
        if (link == null || link.getHref() == null) {
            throw new GedcomxApplicationException("Conclusion cannot be deleted: missing link.");
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "DELETE");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonState addSourceReference(SourceDescriptionState source, StateTransitionOption ... options) {
        SourceReference reference = new SourceReference();
        reference.setDescriptionRef(new URI(source.getSelfUri().toString()));
        return this.addSourceReference(reference, options);
    }

    public PersonState addSourceReference(RecordState source, StateTransitionOption ... options) {
        SourceReference reference = new SourceReference();
        reference.setDescriptionRef(new URI(source.getSelfUri().toString()));
        return this.addSourceReference(reference, options);
    }

    public PersonState addSourceReference(SourceReference reference, StateTransitionOption ... options) {
        return this.addSourceReferences(new SourceReference[]{reference}, options);
    }

    public PersonState addSourceReferences(SourceReference[] refs, StateTransitionOption ... options) {
        Person person = this.createEmptySelf();
        person.setSources(Arrays.asList(refs));
        return this.updateSourceReferences(person, options);
    }

    public PersonState updateSourceReference(SourceReference reference, StateTransitionOption ... options) {
        return this.updateSourceReferences(new SourceReference[]{reference}, options);
    }

    public PersonState updateSourceReferences(SourceReference[] refs, StateTransitionOption ... options) {
        Person person = this.createEmptySelf();
        person.setSources(Arrays.asList(refs));
        return this.updateSourceReferences(person, options);
    }

    public PersonState updateSourceReferences(Person person, StateTransitionOption ... options) {
        java.net.URI target = this.getSelfUri();
        Link conclusionsLink = this.getLink("source-references");
        if (conclusionsLink != null && conclusionsLink.getHref() != null) {
            target = conclusionsLink.getHref().toURI();
        }
        Gedcomx gx = new Gedcomx();
        gx.setPersons(Arrays.asList(person));
        ClientRequest request = ((ClientRequest.Builder)this.createAuthenticatedGedcomxRequest().entity((Object)gx)).build(target, "POST");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonState deleteSourceReference(SourceReference reference, StateTransitionOption ... options) {
        Link link = reference.getLink("source-reference");
        Link link2 = link = link == null ? reference.getLink("self") : link;
        if (link == null || link.getHref() == null) {
            throw new GedcomxApplicationException("Source reference cannot be deleted: missing link.");
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "DELETE");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }

    public SourceDescriptionState readSourceDescription(SourceReference sourceReference, StateTransitionOption ... options) {
        Link link = sourceReference.getLink("description");
        link = link == null ? sourceReference.getLink("self") : link;
        URI href = link != null ? link.getHref() : sourceReference.getDescriptionRef();
        if (href == null) {
            throw new GedcomxApplicationException("Source description cannot be read: missing link.");
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(href.toURI(), "GET");
        return this.stateFactory.newSourceDescriptionState(request, this.invoke(request, options), this.accessToken);
    }

    public SourceDescriptionsState readArtifacts(StateTransitionOption ... options) {
        Link link = this.getLink("artifacts");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newSourceDescriptionsState(request, this.invoke(request, options), this.accessToken);
    }

    public SourceDescriptionState addArtifact(DataSource artifact, StateTransitionOption ... options) {
        return this.addArtifact(null, artifact, options);
    }

    public SourceDescriptionState addArtifact(SourceDescription description, DataSource artifact, StateTransitionOption ... options) {
        return CollectionState.addArtifact(this, description, artifact, options);
    }

    public PersonState addMediaReference(SourceDescriptionState description, StateTransitionOption ... options) {
        SourceReference reference = new SourceReference();
        reference.setDescriptionRef(new URI(description.getSelfUri().toString()));
        return this.addMediaReference(reference, options);
    }

    public PersonState addMediaReference(SourceReference reference, StateTransitionOption ... options) {
        return this.addMediaReferences(new SourceReference[]{reference}, options);
    }

    public PersonState addMediaReferences(SourceReference[] refs, StateTransitionOption ... options) {
        Person person = this.createEmptySelf();
        person.setMedia(Arrays.asList(refs));
        return this.updateMediaReferences(person, options);
    }

    public PersonState updateMediaReference(SourceReference reference, StateTransitionOption ... options) {
        return this.updateMediaReferences(new SourceReference[]{reference}, options);
    }

    public PersonState updateMediaReferences(SourceReference[] refs, StateTransitionOption ... options) {
        Person person = this.createEmptySelf();
        person.setMedia(Arrays.asList(refs));
        return this.updateMediaReferences(person, options);
    }

    public PersonState updateMediaReferences(Person person, StateTransitionOption ... options) {
        java.net.URI target = this.getSelfUri();
        Link conclusionsLink = this.getLink("media-references");
        if (conclusionsLink != null && conclusionsLink.getHref() != null) {
            target = conclusionsLink.getHref().toURI();
        }
        Gedcomx gx = new Gedcomx();
        gx.setPersons(Arrays.asList(person));
        ClientRequest request = ((ClientRequest.Builder)this.createAuthenticatedGedcomxRequest().entity((Object)gx)).build(target, "POST");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonState deleteMediaReference(SourceReference reference, StateTransitionOption ... options) {
        Link link = reference.getLink("media-reference");
        Link link2 = link = link == null ? reference.getLink("self") : link;
        if (link == null || link.getHref() == null) {
            throw new GedcomxApplicationException("Media reference cannot be deleted: missing link.");
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "DELETE");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonState addEvidenceReference(PersonState evidence, StateTransitionOption ... options) {
        EvidenceReference reference = new EvidenceReference();
        reference.setResource(new URI(evidence.getSelfUri().toString()));
        return this.addEvidenceReference(reference, options);
    }

    public PersonState addEvidenceReference(EvidenceReference reference, StateTransitionOption ... options) {
        return this.addEvidenceReferences(new EvidenceReference[]{reference}, options);
    }

    public PersonState addEvidenceReferences(EvidenceReference[] refs, StateTransitionOption ... options) {
        Person person = this.createEmptySelf();
        person.setEvidence(Arrays.asList(refs));
        return this.updateEvidenceReferences(person, options);
    }

    public PersonState updateEvidenceReference(EvidenceReference reference, StateTransitionOption ... options) {
        return this.updateEvidenceReferences(new EvidenceReference[]{reference}, options);
    }

    public PersonState updateEvidenceReferences(EvidenceReference[] refs, StateTransitionOption ... options) {
        Person person = this.createEmptySelf();
        person.setEvidence(Arrays.asList(refs));
        return this.updateEvidenceReferences(person, options);
    }

    public PersonState updateEvidenceReferences(Person person, StateTransitionOption ... options) {
        java.net.URI target = this.getSelfUri();
        Link conclusionsLink = this.getLink("evidence-references");
        if (conclusionsLink != null && conclusionsLink.getHref() != null) {
            target = conclusionsLink.getHref().toURI();
        }
        Gedcomx gx = new Gedcomx();
        gx.setPersons(Arrays.asList(person));
        ClientRequest request = ((ClientRequest.Builder)this.createAuthenticatedGedcomxRequest().entity((Object)gx)).build(target, "POST");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonState deleteEvidenceReference(EvidenceReference reference, StateTransitionOption ... options) {
        Link link = reference.getLink("evidence-reference");
        Link link2 = link = link == null ? reference.getLink("self") : link;
        if (link == null || link.getHref() == null) {
            throw new GedcomxApplicationException("Evidence reference cannot be deleted: missing link.");
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "DELETE");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonState addPersonaReference(PersonState persona, StateTransitionOption ... options) {
        return this.addEvidenceReference(persona, options);
    }

    public PersonState addPersonaReference(EvidenceReference reference, StateTransitionOption ... options) {
        return this.addEvidenceReference(reference, options);
    }

    public PersonState addPersonaReferences(EvidenceReference[] refs, StateTransitionOption ... options) {
        return this.addEvidenceReferences(refs, options);
    }

    public PersonState updatePersonaReference(EvidenceReference reference, StateTransitionOption ... options) {
        return this.updateEvidenceReference(reference, options);
    }

    public PersonState updatePersonaReferences(EvidenceReference[] refs, StateTransitionOption ... options) {
        return this.updateEvidenceReferences(refs, options);
    }

    public PersonState updatePersonaReferences(Person person, StateTransitionOption ... options) {
        return this.updateEvidenceReferences(person, options);
    }

    public PersonState deletePersonaReference(EvidenceReference reference, StateTransitionOption ... options) {
        return this.deleteEvidenceReference(reference, options);
    }

    public PersonState readNote(Note note, StateTransitionOption ... options) {
        Link link = note.getLink("note");
        Link link2 = link = link == null ? note.getLink("self") : link;
        if (link == null || link.getHref() == null) {
            throw new GedcomxApplicationException("Note cannot be read: missing link.");
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonState addNote(Note note, StateTransitionOption ... options) {
        return this.addNotes(new Note[]{note}, options);
    }

    public PersonState addNotes(Note[] notes, StateTransitionOption ... options) {
        Person person = this.createEmptySelf();
        person.setNotes(Arrays.asList(notes));
        return this.updateNotes(person, options);
    }

    public PersonState updateNote(Note note, StateTransitionOption ... options) {
        return this.updateNotes(new Note[]{note}, options);
    }

    public PersonState updateNotes(Note[] notes, StateTransitionOption ... options) {
        Person person = this.createEmptySelf();
        person.setNotes(Arrays.asList(notes));
        return this.updateNotes(person, options);
    }

    public PersonState updateNotes(Person person, StateTransitionOption ... options) {
        java.net.URI target = this.getSelfUri();
        Link conclusionsLink = this.getLink("notes");
        if (conclusionsLink != null && conclusionsLink.getHref() != null) {
            target = conclusionsLink.getHref().toURI();
        }
        Gedcomx gx = new Gedcomx();
        gx.setPersons(Arrays.asList(person));
        ClientRequest request = ((ClientRequest.Builder)this.createAuthenticatedGedcomxRequest().entity((Object)gx)).build(target, "POST");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonState deleteNote(Note note, StateTransitionOption ... options) {
        Link link = note.getLink("note");
        Link link2 = link = link == null ? note.getLink("self") : link;
        if (link == null || link.getHref() == null) {
            throw new GedcomxApplicationException("Note cannot be deleted: missing link.");
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "DELETE");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }

    public RelationshipState readRelationship(Relationship relationship, StateTransitionOption ... options) {
        Link link = relationship.getLink("relationship");
        Link link2 = link = link == null ? relationship.getLink("self") : link;
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newRelationshipState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonState readRelative(Relationship relationship, StateTransitionOption ... options) {
        ResourceReference reference = null;
        if (this.refersToMe(relationship.getPerson1())) {
            reference = relationship.getPerson2();
        } else if (this.refersToMe(relationship.getPerson2())) {
            reference = relationship.getPerson1();
        }
        if (reference == null || reference.getResource() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(reference.getResource().toURI(), "GET");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonState readFirstSpouse(StateTransitionOption ... options) {
        return this.readSpouse(0, options);
    }

    public PersonState readSpouse(int index, StateTransitionOption ... options) {
        List<Relationship> spouseRelationships = this.getSpouseRelationships();
        if (spouseRelationships.size() <= index) {
            return null;
        }
        return this.readSpouse(spouseRelationships.get(index), options);
    }

    public PersonState readSpouse(Relationship relationship, StateTransitionOption ... options) {
        return this.readRelative(relationship, options);
    }

    public PersonSpousesState readSpouses(StateTransitionOption ... options) {
        Link link = this.getLink("spouses");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newPersonSpousesState(request, this.invoke(request, options), this.accessToken);
    }

    public RelationshipState addSpouse(PersonState person, StateTransitionOption ... options) {
        CollectionState collection = this.readCollection(new StateTransitionOption[0]);
        if (collection == null || collection.hasError()) {
            throw new GedcomxApplicationException("Unable to add relationship: collection unavailable.");
        }
        return collection.addSpouseRelationship(this, person, options);
    }

    public PersonState readFirstChild(StateTransitionOption ... options) {
        return this.readChild(0, options);
    }

    public PersonState readChild(int index, StateTransitionOption ... options) {
        List<Relationship> childRelationships = this.getChildRelationships();
        if (childRelationships.size() <= index) {
            return null;
        }
        return this.readChild(childRelationships.get(index), options);
    }

    public PersonState readChild(Relationship relationship, StateTransitionOption ... options) {
        return this.readRelative(relationship, options);
    }

    public PersonChildrenState readChildren(StateTransitionOption ... options) {
        Link link = this.getLink("children");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newPersonChildrenState(request, this.invoke(request, options), this.accessToken);
    }

    public RelationshipState addChild(PersonState person, StateTransitionOption ... options) {
        CollectionState collection = this.readCollection(new StateTransitionOption[0]);
        if (collection == null || collection.hasError()) {
            throw new GedcomxApplicationException("Unable to add relationship: collection unavailable.");
        }
        return collection.addParentChildRelationship(this, person, options);
    }

    public PersonState readFirstParent(StateTransitionOption ... options) {
        return this.readParent(0, options);
    }

    public PersonState readParent(int index, StateTransitionOption ... options) {
        List<Relationship> parentRelationships = this.getParentRelationships();
        if (parentRelationships.size() <= index) {
            return null;
        }
        return this.readParent(parentRelationships.get(index), options);
    }

    public PersonState readParent(Relationship relationship, StateTransitionOption ... options) {
        return this.readRelative(relationship, options);
    }

    public PersonParentsState readParents(StateTransitionOption ... options) {
        Link link = this.getLink("parents");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newPersonParentsState(request, this.invoke(request, options), this.accessToken);
    }

    public RelationshipState addParent(PersonState person, StateTransitionOption ... options) {
        CollectionState collection = this.readCollection(new StateTransitionOption[0]);
        if (collection == null || collection.hasError()) {
            throw new GedcomxApplicationException("Unable to add relationship: collection unavailable.");
        }
        return collection.addParentChildRelationship(person, this, options);
    }
}

