/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rs.client.options;

import com.sun.jersey.api.client.ClientRequest;
import java.util.Date;
import org.gedcomx.rs.client.GedcomxApplicationState;
import org.gedcomx.rs.client.StateTransitionOption;

public class CacheDirectives
implements StateTransitionOption {
    private final String etag;
    private final Date lastModified;

    public CacheDirectives(GedcomxApplicationState state) {
        this(state.getETag() == null ? null : state.getETag().toString(), state.getLastModified());
    }

    public CacheDirectives(Date lastModified) {
        this(null, lastModified);
    }

    public CacheDirectives(String etag) {
        this(etag, null);
    }

    public CacheDirectives(String etag, Date lastModified) {
        this.etag = etag;
        this.lastModified = lastModified;
    }

    @Override
    public void apply(ClientRequest request) {
        if (this.etag != null) {
            request.getHeaders().putSingle((Object)"If-None-Match", (Object)this.etag);
        }
        if (this.lastModified != null) {
            request.getHeaders().putSingle((Object)"If-Modified-Since", (Object)this.lastModified);
        }
    }
}

