/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.util.Arrays;
import javax.security.jacc.URLPattern;

class URLPatternSpec
extends URLPattern {
    private static String DEFAULT_PATTERN = "/";
    private static String EMPTY_STRING = "";
    private transient int hashCodeValue = 0;
    private String canonicalSpec = null;
    private final String urlPatternList;
    private URLPattern[] urlPatternArray = null;

    public URLPatternSpec(String urlPatternSpec) {
        super(URLPatternSpec.getFirstPattern(urlPatternSpec));
        int colon = urlPatternSpec.indexOf(":");
        if (colon >= 0) {
            this.urlPatternList = urlPatternSpec.substring(colon + 1);
            this.setURLPatternArray();
        } else {
            this.urlPatternList = null;
        }
    }

    public String getURLPattern() {
        return super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof URLPatternSpec)) {
            return false;
        }
        URLPatternSpec that = (URLPatternSpec)o;
        return this.toString().equals(that.toString());
    }

    public int hashCode() {
        if (this.hashCodeValue == 0) {
            this.hashCodeValue = this.toString().hashCode();
        }
        return this.hashCodeValue;
    }

    public boolean implies(URLPatternSpec that) {
        if (that == null) {
            return false;
        }
        if (!super.implies(that)) {
            return false;
        }
        for (int i = 0; this.urlPatternArray != null && i < this.urlPatternArray.length; ++i) {
            if (this.urlPatternArray[i] == null || !this.urlPatternArray[i].implies(that)) continue;
            return false;
        }
        if (this.urlPatternArray != null && that.implies((URLPattern)this)) {
            if (that.urlPatternArray == null) {
                return false;
            }
            boolean[] flags = new boolean[this.urlPatternArray.length];
            for (int i = 0; i < flags.length; ++i) {
                flags[i] = false;
            }
            int count = 0;
            for (int j = 0; j < that.urlPatternArray.length; ++j) {
                for (int i = 0; i < flags.length; ++i) {
                    if (flags[i] || this.urlPatternArray[i] != null && (that.urlPatternArray[j] == null || !that.urlPatternArray[j].implies(this.urlPatternArray[i]))) continue;
                    flags[i] = true;
                    if (++count != flags.length) continue;
                    return true;
                }
            }
            return count == flags.length;
        }
        return true;
    }

    @Override
    public String toString() {
        if (this.canonicalSpec == null) {
            if (this.urlPatternList == null) {
                this.canonicalSpec = super.toString();
            } else {
                StringBuffer s = null;
                for (int i = 0; i < this.urlPatternArray.length; ++i) {
                    if (this.urlPatternArray[i] == null) continue;
                    if (s == null) {
                        s = new StringBuffer(this.urlPatternArray[i].toString());
                        continue;
                    }
                    s.append(":" + this.urlPatternArray[i].toString());
                }
                this.canonicalSpec = s == null ? super.toString() : super.toString() + ":" + s.toString();
            }
        }
        return this.canonicalSpec;
    }

    private static String getFirstPattern(String urlPatternSpec) {
        if (urlPatternSpec == null) {
            throw new IllegalArgumentException("Invalid URLPatternSpec");
        }
        int colon = urlPatternSpec.indexOf(":");
        if (colon < 0) {
            return urlPatternSpec;
        }
        if (colon > 0) {
            return urlPatternSpec.substring(0, colon);
        }
        if (colon == 0) {
            return EMPTY_STRING;
        }
        throw new IllegalArgumentException("Invalid URLPatternSpec");
    }

    private void setURLPatternArray() {
        if (this.urlPatternArray == null && this.urlPatternList != null) {
            int i;
            String[] tokens = this.urlPatternList.split(":", -1);
            int count = tokens.length;
            if (count == 0) {
                throw new IllegalArgumentException("colon followed by empty URLPatternList");
            }
            this.urlPatternArray = new URLPattern[count];
            int firstType = this.patternType();
            block12: for (i = 0; i < count; ++i) {
                this.urlPatternArray[i] = new URLPattern(tokens[i]);
                if (this.urlPatternArray[i].implies(this)) {
                    throw new IllegalArgumentException("pattern in URLPatternList implies first pattern");
                }
                switch (firstType) {
                    case 1: 
                    case 2: {
                        switch (this.urlPatternArray[i].patternType()) {
                            case 2: {
                                if (firstType != 2 || !super.equals(this.urlPatternArray[i]) && super.implies(this.urlPatternArray[i])) break;
                                throw new IllegalArgumentException("Invalid prefix pattern in URLPatternList");
                            }
                            case 3: {
                                if (super.implies(this.urlPatternArray[i])) break;
                                throw new IllegalArgumentException("Invalid exact pattern in URLPatternList");
                            }
                            default: {
                                throw new IllegalArgumentException("Invalid pattern type in URLPatternList");
                            }
                        }
                    }
                    case 0: {
                        if (!super.equals(this.urlPatternArray[i])) continue block12;
                        throw new IllegalArgumentException("Invalid default pattern in URLPatternList");
                    }
                    case 3: {
                        throw new IllegalArgumentException("invalid URLPatternSpec");
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid pattern type in URLPatternList");
                    }
                }
            }
            Arrays.sort(this.urlPatternArray);
            block13: for (i = 0; i < this.urlPatternArray.length; ++i) {
                if (this.urlPatternArray[i] == null) continue;
                switch (this.urlPatternArray[i].patternType()) {
                    case 2: {
                        for (int j = i + 1; j < this.urlPatternArray.length; ++j) {
                            if (!this.urlPatternArray[i].implies(this.urlPatternArray[j])) continue;
                            this.urlPatternArray[j] = null;
                        }
                        continue block13;
                    }
                }
            }
        }
    }
}

