/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.model.resources;

import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ResourceFilter {
    private final Pattern excludes;

    public ResourceFilter(Set<String> regularExpressions) {
        this.excludes = regularExpressions.isEmpty() ? null : Pattern.compile(regularExpressions.stream().map(p -> "(" + p + ")").collect(Collectors.joining("|")));
    }

    public boolean shouldIncludeResource(String name) {
        return this.excludes == null || !this.excludes.matcher(name).find();
    }
}

