/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.enterprise.builtins.objects.struct;

import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.strings.TruffleString;

public final class FormatDef {
    public final char format;
    public final int size;
    public final int alignment;
    public final boolean unsigned;
    public final long min;
    public final long max;
    public final TruffleString name;
    public final boolean integer;
    private final TruffleString label;
    private static final TruffleString T_UBYTE = PythonUtils.tsLiteral((String)"ubyte");
    private static final TruffleString T_BYTE = PythonUtils.tsLiteral((String)"byte");
    private static final TruffleString T_USHORT = PythonUtils.tsLiteral((String)"ushort");
    private static final TruffleString T_SHORT = PythonUtils.tsLiteral((String)"short");
    private static final TruffleString T_UINT = PythonUtils.tsLiteral((String)"uint");
    private static final TruffleString T_INT = PythonUtils.tsLiteral((String)"int");
    private static final TruffleString T_ULONG = PythonUtils.tsLiteral((String)"ulong");
    private static final TruffleString T_LONG = PythonUtils.tsLiteral((String)"long");

    public FormatDef(char format, TruffleString label, int size, int alignment) {
        this.format = format;
        this.label = label;
        this.size = size;
        this.alignment = alignment;
        this.unsigned = this.format == 'B' || this.format == 'H' || this.format == 'I' || this.format == 'L' || this.format == 'Q' || this.format == 'N';
        boolean bl = this.integer = this.format == 'b' || this.format == 'B' || this.format == 'h' || this.format == 'H' || this.format == 'i' || this.format == 'I' || this.format == 'l' || this.format == 'L' || this.format == 'q' || this.format == 'Q' || this.format == 'n' || this.format == 'N';
        if (this.size == 1) {
            this.name = this.unsigned ? T_UBYTE : T_BYTE;
            this.min = this.unsigned ? 0L : -128L;
            this.max = this.unsigned ? 255L : 127L;
        } else if (this.size == 2) {
            this.name = this.unsigned ? T_USHORT : T_SHORT;
            this.min = this.unsigned ? 0L : -32768L;
            this.max = this.unsigned ? 65535L : 32767L;
        } else if (this.size == 4) {
            this.name = this.unsigned ? T_UINT : T_INT;
            this.min = this.unsigned ? 0L : Integer.MIN_VALUE;
            this.max = this.unsigned ? 0xFFFFFFFFL : Integer.MAX_VALUE;
        } else if (this.size == 8) {
            this.name = this.unsigned ? T_ULONG : T_LONG;
            this.min = this.unsigned ? 0L : Long.MIN_VALUE;
            this.max = this.unsigned ? -1L : Long.MAX_VALUE;
        } else {
            this.name = null;
            this.min = -1L;
            this.max = -1L;
        }
    }

    public String toString() {
        return PythonUtils.formatJString((String)"%s(%c,%d,%d)", (Object[])new Object[]{this.label, Character.valueOf(this.format), this.size, this.alignment});
    }
}

