/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.enterprise.builtins.objects.struct;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.enterprise.builtins.nodes.EnterpriseErrorMessages;
import com.oracle.graal.python.enterprise.builtins.objects.iterator.PStructUnpackIterator;
import com.oracle.graal.python.enterprise.builtins.objects.struct.FormatCode;
import com.oracle.graal.python.enterprise.builtins.objects.struct.PStruct;
import com.oracle.graal.python.enterprise.builtins.objects.struct.StructBuiltinsClinicProviders;
import com.oracle.graal.python.enterprise.builtins.objects.struct.StructBuiltinsFactory;
import com.oracle.graal.python.enterprise.builtins.objects.struct.StructNodes;
import com.oracle.graal.python.enterprise.builtins.runtime.object.EnterprisePythonObjectFactory;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PStruct})
public class StructBuiltins
extends PythonBuiltins {
    static void packInternal(VirtualFrame frame, PStruct self, StructNodes.PackValueNode packValueNode, Object[] args, byte[] buffer, int offset) {
        assert (self.getSize() <= buffer.length - offset);
        FormatCode[] codes = self.getCodes();
        int pos = 0;
        for (FormatCode code : codes) {
            int buffer_offset = offset + code.offset;
            int j = 0;
            while (j < code.repeat) {
                packValueNode.execute(frame, code, self.formatAlignment, args[pos], buffer, buffer_offset);
                buffer_offset += code.size;
                ++j;
                ++pos;
            }
        }
    }

    public static Object[] unpackInternal(PStruct self, StructNodes.UnpackValueNode unpackValueNode, byte[] bytes, int offset) {
        Object[] values = new Object[self.getLen()];
        FormatCode[] codes = self.getCodes();
        int pos = 0;
        for (FormatCode code : codes) {
            int buffer_offset = offset + code.offset;
            int j = 0;
            while (j < code.repeat) {
                Object value;
                values[pos] = value = unpackValueNode.execute(code, self.formatAlignment, bytes, buffer_offset);
                buffer_offset += code.size;
                ++j;
                ++pos;
            }
        }
        return values;
    }

    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return StructBuiltinsFactory.getFactories();
    }

    @Builtin(name="format", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetStructFormat
    extends PythonBuiltinNode {
        @Specialization
        protected Object get(PStruct self, @Cached TruffleString.FromByteArrayNode fromBytes, @Cached TruffleString.SwitchEncodingNode switchEncoding) {
            return switchEncoding.execute((AbstractTruffleString)fromBytes.execute(self.getFormat(), TruffleString.Encoding.US_ASCII), PythonUtils.TS_ENCODING);
        }
    }

    @Builtin(name="size", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetStructSizeNode
    extends PythonBuiltinNode {
        @Specialization
        protected Object get(PStruct self) {
            return self.getSize();
        }
    }

    @Builtin(name="calcsize", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class StructCalcSizeNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object calcSize(PStruct self) {
            return self.getSize();
        }
    }

    @Builtin(name="unpack_from", minNumOfPositionalArgs=2, parameterNames={"$self", "buffer", "offset"}, forceSplitDirectCalls=true)
    @ArgumentsClinic(value={@ArgumentClinic(name="buffer", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer), @ArgumentClinic(name="offset", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0")})
    @GenerateNodeFactory
    public static abstract class StructUnpackFromNode
    extends PythonTernaryClinicBuiltinNode {
        public abstract Object execute(VirtualFrame var1, PStruct var2, Object var3, int var4);

        protected ArgumentClinicProvider getArgumentClinic() {
            return StructBuiltinsClinicProviders.StructUnpackFromNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static Object unpackFrom(VirtualFrame frame, PStruct self, Object buffer, int offset, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Cached StructNodes.UnpackValueNode unpackValueNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                int bufferOffset = offset;
                int bytesLen = bufferLib.getBufferLength(buffer);
                byte[] bytes = bufferLib.getInternalOrCopiedByteArray(buffer);
                long size = self.getUnsignedSize();
                if (bufferOffset < 0) {
                    if ((long)bufferOffset + size > 0L) {
                        throw raiseNode.get(inliningTarget).raise(PythonErrorType.StructError, EnterpriseErrorMessages.STRUCT_NOT_ENOUGH_DATA_TO_UNPACK_N_BYTES, new Object[]{size, bufferOffset});
                    }
                    if (bufferOffset + bytesLen < 0) {
                        throw raiseNode.get(inliningTarget).raise(PythonErrorType.StructError, EnterpriseErrorMessages.STRUCT_OFFSET_OUT_OF_RANGE, new Object[]{bufferOffset, bytesLen});
                    }
                    bufferOffset += bytesLen;
                }
                if ((long)(bytesLen - bufferOffset) < size) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.StructError, EnterpriseErrorMessages.STRUCT_UNPACK_FROM_REQ_AT_LEAST_N_BYTES, new Object[]{size + (long)bufferOffset, size, bufferOffset, bytesLen});
                }
                PTuple pTuple = factory.createTuple(StructBuiltins.unpackInternal(self, unpackValueNode, bytes, bufferOffset));
                return pTuple;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }
    }

    @Builtin(name="iter_unpack", minNumOfPositionalArgs=2, parameterNames={"$self", "buffer"}, forceSplitDirectCalls=true)
    @ArgumentClinic(name="buffer", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)
    @GenerateNodeFactory
    public static abstract class StructIterUnpackNode
    extends PythonBinaryClinicBuiltinNode {
        public abstract Object execute(VirtualFrame var1, PStruct var2, Object var3);

        protected ArgumentClinicProvider getArgumentClinic() {
            return StructBuiltinsClinicProviders.StructIterUnpackNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(limit="3")
        static Object iterUnpack(VirtualFrame frame, PStruct self, Object buffer, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                if (self.getSize() == 0) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.StructError, EnterpriseErrorMessages.STRUCT_ITER_CANNOT_UNPACK_FROM_STRUCT_OF_SIZE_0);
                }
                int bufferLen = bufferLib.getBufferLength(buffer);
                if (bufferLen % self.getSize() != 0) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.StructError, EnterpriseErrorMessages.STRUCT_ITER_UNPACK_REQ_A_BUFFER_OF_A_MUL_OF_BYTES, new Object[]{self.getSize()});
                }
            }
            catch (Exception e) {
                bufferLib.release(buffer, frame, indirectCallData);
                throw e;
            }
            PStructUnpackIterator structUnpackIterator = EnterprisePythonObjectFactory.createStructUnpackIterator(factory, self, buffer);
            structUnpackIterator.index = 0;
            return structUnpackIterator;
        }
    }

    @Builtin(name="unpack", minNumOfPositionalArgs=2, parameterNames={"$self", "buffer"}, forceSplitDirectCalls=true)
    @ArgumentClinic(name="buffer", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)
    @GenerateNodeFactory
    public static abstract class StructUnpackNode
    extends PythonBinaryClinicBuiltinNode {
        public abstract Object execute(VirtualFrame var1, PStruct var2, Object var3);

        protected ArgumentClinicProvider getArgumentClinic() {
            return StructBuiltinsClinicProviders.StructUnpackNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static Object unpack(VirtualFrame frame, PStruct self, Object buffer, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Cached StructNodes.UnpackValueNode unpackValueNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                int bytesLen = bufferLib.getBufferLength(buffer);
                byte[] bytes = bufferLib.getInternalOrCopiedByteArray(buffer);
                if (bytesLen != self.getSize()) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.StructError, EnterpriseErrorMessages.UNPACK_REQ_A_BUFFER_OF_N_BYTES, new Object[]{self.getSize()});
                }
                PTuple pTuple = factory.createTuple(StructBuiltins.unpackInternal(self, unpackValueNode, bytes, 0));
                return pTuple;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }
    }

    @Builtin(name="pack_into", minNumOfPositionalArgs=3, parameterNames={"$self", "buffer", "offset"}, takesVarArgs=true, forceSplitDirectCalls=true)
    @ArgumentsClinic(value={@ArgumentClinic(name="buffer", conversion=ArgumentClinic.ClinicConversion.WritableBuffer), @ArgumentClinic(name="offset", conversion=ArgumentClinic.ClinicConversion.Int)})
    @GenerateNodeFactory
    public static abstract class StructPackIntoNode
    extends PythonClinicBuiltinNode {
        public abstract Object execute(VirtualFrame var1, PStruct var2, Object var3, int var4, Object[] var5);

        protected ArgumentClinicProvider getArgumentClinic() {
            return StructBuiltinsClinicProviders.StructPackIntoNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static Object packInto(VirtualFrame frame, PStruct self, Object buffer, int offset, Object[] args, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Cached StructNodes.PackValueNode packValueNode, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                long size = self.getUnsignedSize();
                if (args.length != self.getLen()) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.StructError, EnterpriseErrorMessages.STRUCT_PACK_EXPECTED_N_ITEMS_GOT_K, new Object[]{size, args.length});
                }
                int bufferOffset = offset;
                int bufferLen = bufferLib.getBufferLength(buffer);
                boolean directWrite = bufferLib.hasInternalByteArray(buffer);
                byte[] bytes = directWrite ? bufferLib.getInternalByteArray(buffer) : new byte[self.getSize()];
                if (bufferOffset < 0) {
                    if ((long)bufferOffset + size > 0L) {
                        throw raiseNode.get(inliningTarget).raise(PythonErrorType.StructError, EnterpriseErrorMessages.STRUCT_NO_SPACE_TO_PACK_N_BYTES, new Object[]{size, bufferOffset});
                    }
                    if (bufferOffset + bufferLen < 0) {
                        throw raiseNode.get(inliningTarget).raise(PythonErrorType.StructError, EnterpriseErrorMessages.STRUCT_OFFSET_OUT_OF_RANGE, new Object[]{bufferOffset, bufferLen});
                    }
                    bufferOffset += bufferLen;
                }
                if ((long)(bufferLen - bufferOffset) < size) {
                    assert (bufferOffset >= 0);
                    assert (size >= 0L);
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.StructError, EnterpriseErrorMessages.STRUCT_PACK_INTO_REQ_BUFFER_TO_PACK, new Object[]{size + (long)bufferOffset, size, bufferOffset, bufferLen});
                }
                StructBuiltins.packInternal(frame, self, packValueNode, args, bytes, directWrite ? bufferOffset : 0);
                if (!directWrite) {
                    bufferLib.writeFromByteArray(buffer, bufferOffset, bytes, 0, bytes.length);
                }
                PNone pNone = PNone.NONE;
                return pNone;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @NeverDefault
        public static StructPackIntoNode create() {
            return StructBuiltinsFactory.StructPackIntoNodeFactory.create(null);
        }
    }

    @Builtin(name="pack", minNumOfPositionalArgs=1, parameterNames={"$self"}, takesVarArgs=true, takesVarKeywordArgs=true, forceSplitDirectCalls=true)
    @GenerateNodeFactory
    public static abstract class StructPackNode
    extends PythonVarargsBuiltinNode {
        public final Object execute(VirtualFrame frame, PStruct self, Object[] args) {
            return this.execute(frame, (Object)self, args, PKeyword.EMPTY_KEYWORDS);
        }

        public Object varArgExecute(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) throws PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported {
            return this.execute(frame, self, arguments, PKeyword.EMPTY_KEYWORDS);
        }

        @Specialization
        Object pack(VirtualFrame frame, PStruct self, Object[] args, PKeyword[] keywords, @Cached StructNodes.PackValueNode packValueNode, @Cached PythonObjectFactory factory) {
            if (keywords.length != 0) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.S_TAKES_NO_KEYWORD_ARGS, new Object[]{"pack()"});
            }
            if (args.length != self.getLen()) {
                throw this.raise(PythonErrorType.StructError, EnterpriseErrorMessages.STRUCT_PACK_EXPECTED_N_ITEMS_GOT_K, new Object[]{self.getSize(), args.length});
            }
            byte[] bytes = new byte[self.getSize()];
            StructBuiltins.packInternal(frame, self, packValueNode, args, bytes, 0);
            return factory.createBytes(bytes);
        }
    }
}

