/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.jvm.dependency.conflict.detection;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.ComponentMetadataHandler;
import org.gradle.api.initialization.Settings;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JvmEcosystemPlugin;
import org.gradle.util.GradleVersion;
import org.gradlex.jvm.dependency.conflict.detection.rules.AlignmentDefinition;
import org.gradlex.jvm.dependency.conflict.detection.rules.CapabilityDefinition;

public class JvmDependencyConflictDetectionPlugin
implements Plugin<ExtensionAware> {
    private static final GradleVersion MINIMUM_SUPPORTED_VERSION = GradleVersion.version((String)"6.8.3");

    public void apply(ExtensionAware projectOrSettings) {
        ComponentMetadataHandler components;
        if (GradleVersion.current().compareTo(MINIMUM_SUPPORTED_VERSION) < 0) {
            throw new IllegalStateException("Plugin requires at least Gradle " + MINIMUM_SUPPORTED_VERSION.getVersion());
        }
        if (projectOrSettings instanceof Project) {
            ((Project)projectOrSettings).getPlugins().apply(JvmEcosystemPlugin.class);
            components = ((Project)projectOrSettings).getDependencies().getComponents();
        } else if (projectOrSettings instanceof Settings) {
            components = ((Settings)projectOrSettings).getDependencyResolutionManagement().getComponents();
        } else {
            throw new IllegalStateException("Cannot apply plugin to: " + projectOrSettings.getClass().getName());
        }
        this.registerRules(components);
    }

    private void registerRules(ComponentMetadataHandler components) {
        for (CapabilityDefinition capabilityDefinition : CapabilityDefinition.values()) {
            this.registerCapabilityRule(capabilityDefinition, components);
        }
        for (Enum enum_ : AlignmentDefinition.values()) {
            this.registerAlignmentRule((AlignmentDefinition)enum_, components);
        }
    }

    private void registerCapabilityRule(CapabilityDefinition definition, ComponentMetadataHandler components) {
        for (String module : definition.getModules()) {
            components.withModule((Object)module, definition.getRuleClass(), ac -> ac.params(new Object[]{definition}));
        }
    }

    private void registerAlignmentRule(AlignmentDefinition definition, ComponentMetadataHandler components) {
        for (String module : definition.getModules()) {
            components.withModule((Object)module, definition.getRuleClass(), ac -> ac.params(new Object[]{definition}));
        }
    }
}

