/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.jvm.dependency.conflict.detection.rules;

import javax.inject.Inject;
import org.gradle.api.artifacts.CacheableRule;
import org.gradle.api.artifacts.ComponentMetadataContext;
import org.gradle.api.artifacts.ComponentMetadataDetails;
import org.gradle.api.artifacts.ComponentMetadataRule;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.attributes.Category;
import org.gradle.api.model.ObjectFactory;
import org.gradlex.jvm.dependency.conflict.detection.rules.AlignmentDefinition;

@CacheableRule
public abstract class AlignmentDefinitionRule
implements ComponentMetadataRule {
    private final AlignmentDefinition definition;

    @Inject
    public AlignmentDefinitionRule(AlignmentDefinition definition) {
        this.definition = definition;
    }

    @Inject
    protected abstract ObjectFactory getObjects();

    public final void execute(ComponentMetadataContext context) {
        ComponentMetadataDetails details = context.getDetails();
        if (this.shouldApply(details.getId())) {
            if (this.definition.hasBom()) {
                this.applyWithBom(details);
            } else {
                this.applyWithoutBom(details);
            }
        }
    }

    void applyWithBom(ComponentMetadataDetails details) {
        String version = details.getId().getVersion();
        details.allVariants(v -> v.withDependencies(dependencies -> dependencies.add(this.definition.getBom() + ":" + version, d -> d.attributes(a -> a.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)this.getObjects().named(Category.class, "platform")))))));
    }

    void applyWithoutBom(ComponentMetadataDetails details) {
        String version = details.getId().getVersion();
        String group = details.getId().getGroup();
        details.allVariants(v -> v.withDependencyConstraints(c -> {
            for (String member : this.definition.getModules()) {
                if (member.contains(":")) {
                    c.add(member + ":" + version);
                    continue;
                }
                c.add(group + ":" + member + ":" + version);
            }
        }));
    }

    protected boolean shouldApply(ModuleVersionIdentifier id) {
        return true;
    }
}

