/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.jvm.dependency.conflict.detection.rules;

import javax.inject.Inject;
import org.gradle.api.artifacts.CacheableRule;
import org.gradle.api.artifacts.ComponentMetadataContext;
import org.gradle.api.artifacts.ComponentMetadataRule;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.VariantMetadata;
import org.gradlex.jvm.dependency.conflict.detection.rules.CapabilityDefinition;

@CacheableRule
public abstract class CapabilityDefinitionRule
implements ComponentMetadataRule {
    private final CapabilityDefinition definition;

    @Inject
    public CapabilityDefinitionRule(CapabilityDefinition definition) {
        this.definition = definition;
    }

    public final void execute(ComponentMetadataContext context) {
        if (this.shouldApply(context.getDetails().getId())) {
            context.getDetails().allVariants(variant -> {
                variant.withCapabilities(capabilities -> {
                    capabilities.removeCapability(this.definition.getGroup(), this.definition.getCapabilityName());
                    capabilities.addCapability(this.definition.getGroup(), this.definition.getCapabilityName(), this.getVersion(context.getDetails().getId()));
                });
                this.additionalAdjustments((VariantMetadata)variant);
            });
        }
    }

    protected boolean shouldApply(ModuleVersionIdentifier id) {
        return true;
    }

    protected String getVersion(ModuleVersionIdentifier id) {
        return id.getVersion();
    }

    protected void additionalAdjustments(VariantMetadata variant) {
    }
}

