/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.jvm.dependency.conflict.detection.rules.jakarta;

import javax.inject.Inject;
import org.gradle.api.artifacts.CacheableRule;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradlex.jvm.dependency.conflict.detection.rules.CapabilityDefinition;
import org.gradlex.jvm.dependency.conflict.detection.rules.CapabilityDefinitionRule;
import org.gradlex.jvm.dependency.conflict.detection.util.VersionNumber;

@CacheableRule
public abstract class JavaxMailApiRule
extends CapabilityDefinitionRule {
    static final String FIRST_JAKARTA_VERSION = "2.0.0";

    @Inject
    public JavaxMailApiRule(CapabilityDefinition rule) {
        super(rule);
    }

    @Override
    protected boolean shouldApply(ModuleVersionIdentifier id) {
        return VersionNumber.parse(this.getVersion(id)).compareTo(VersionNumber.parse(FIRST_JAKARTA_VERSION)) < 0;
    }

    @Override
    protected String getVersion(ModuleVersionIdentifier id) {
        String group = id.getGroup();
        if (group.equals("org.apache.geronimo.javamail") || group.equals("org.apache.geronimo.specs")) {
            return this.mailApiVersionForGeronimoName(id.getName());
        }
        return id.getVersion();
    }

    private String mailApiVersionForGeronimoName(String name) {
        int index = "geronimo-javamail_".length();
        return name.substring(index, index + 3) + ".0";
    }
}

