/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.jvm.dependency.conflict.detection.rules.jakarta;

import javax.inject.Inject;
import org.gradle.api.artifacts.CacheableRule;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradlex.jvm.dependency.conflict.detection.rules.CapabilityDefinition;
import org.gradlex.jvm.dependency.conflict.detection.rules.CapabilityDefinitionRule;
import org.gradlex.jvm.dependency.conflict.detection.util.VersionNumber;

@CacheableRule
public abstract class JavaxTransactionApiRule
extends CapabilityDefinitionRule {
    static final String FIRST_JAKARTA_VERSION = "2.0.0";

    @Inject
    public JavaxTransactionApiRule(CapabilityDefinition rule) {
        super(rule);
    }

    @Override
    protected boolean shouldApply(ModuleVersionIdentifier id) {
        return VersionNumber.parse(this.getVersion(id)).compareTo(VersionNumber.parse(FIRST_JAKARTA_VERSION)) < 0;
    }

    @Override
    protected String getVersion(ModuleVersionIdentifier id) {
        String name = id.getName();
        String moduleVersion = id.getVersion();
        if (name.contains("jboss-transaction-api_")) {
            return JavaxTransactionApiRule.transactionApiVersionForJbossName(name);
        }
        return moduleVersion;
    }

    private static String transactionApiVersionForJbossName(String name) {
        int index = "jboss-transaction-api_".length();
        return name.substring(index, index + 3) + ".0";
    }
}

