/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.jvm.dependency.conflict.detection.util;

import java.util.Objects;
import javax.annotation.Nullable;

public class VersionNumber
implements Comparable<VersionNumber> {
    private static final VersionNumber UNKNOWN = VersionNumber.version(0, 0);
    private final int major;
    private final int minor;
    private final int micro;
    private final int patch;
    private final String qualifier;

    private VersionNumber(int major, int minor, int micro, int patch, @Nullable String qualifier) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.patch = patch;
        this.qualifier = qualifier;
    }

    @Override
    public int compareTo(VersionNumber other) {
        if (this.major != other.major) {
            return this.major - other.major;
        }
        if (this.minor != other.minor) {
            return this.minor - other.minor;
        }
        if (this.micro != other.micro) {
            return this.micro - other.micro;
        }
        if (this.patch != other.patch) {
            return this.patch - other.patch;
        }
        return this.toLowerCase(this.qualifier).compareTo(this.toLowerCase(other.qualifier));
    }

    private String toLowerCase(@Nullable String string) {
        return string == null ? "" : string.toLowerCase();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof VersionNumber && this.compareTo((VersionNumber)other) == 0;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.micro;
        result = 31 * result + this.patch;
        result = 31 * result + Objects.hashCode(this.qualifier);
        return result;
    }

    public String toString() {
        return String.format("%d.%d.%d%s", this.major, this.minor, this.micro, this.qualifier == null ? "" : "-" + this.qualifier);
    }

    public static VersionNumber version(int major, int minor) {
        return new VersionNumber(major, minor, 0, 0, null);
    }

    public static VersionNumber parse(String versionString) {
        if (versionString == null || versionString.length() == 0) {
            return UNKNOWN;
        }
        Scanner scanner = new Scanner(versionString);
        int major = 0;
        int minor = 0;
        int micro = 0;
        int patch = 0;
        if (!scanner.hasDigit()) {
            return UNKNOWN;
        }
        major = scanner.scanDigit();
        if (scanner.isSeparatorAndDigit('.')) {
            scanner.skipSeparator();
            minor = scanner.scanDigit();
            if (scanner.isSeparatorAndDigit('.')) {
                scanner.skipSeparator();
                micro = scanner.scanDigit();
            }
        }
        if (scanner.isEnd()) {
            return new VersionNumber(major, minor, micro, patch, null);
        }
        if (scanner.isQualifier()) {
            scanner.skipSeparator();
            return new VersionNumber(major, minor, micro, patch, scanner.remainder());
        }
        return UNKNOWN;
    }

    private static class Scanner {
        int pos;
        final String str;

        private Scanner(String string) {
            this.str = string;
        }

        boolean hasDigit() {
            return this.pos < this.str.length() && Character.isDigit(this.str.charAt(this.pos));
        }

        boolean isSeparatorAndDigit(char ... separators) {
            return this.pos < this.str.length() - 1 && this.oneOf(separators) && Character.isDigit(this.str.charAt(this.pos + 1));
        }

        private boolean oneOf(char ... separators) {
            char current = this.str.charAt(this.pos);
            for (char separator : separators) {
                if (current != separator) continue;
                return true;
            }
            return false;
        }

        boolean isQualifier() {
            return this.pos < this.str.length() - 1 && this.oneOf('.', '-');
        }

        int scanDigit() {
            int start = this.pos;
            while (this.hasDigit()) {
                ++this.pos;
            }
            return Integer.parseInt(this.str.substring(start, this.pos));
        }

        public boolean isEnd() {
            return this.pos == this.str.length();
        }

        public void skipSeparator() {
            ++this.pos;
        }

        @Nullable
        public String remainder() {
            return this.pos == this.str.length() ? null : this.str.substring(this.pos);
        }
    }
}

