/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.jvm.dependency.conflict.resolution;

import java.util.Arrays;
import java.util.Optional;
import javax.inject.Inject;
import org.gradle.api.artifacts.CapabilityResolutionDetails;
import org.gradle.api.artifacts.ComponentVariantIdentifier;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.provider.SetProperty;
import org.gradlex.jvm.dependency.conflict.detection.rules.CapabilityDefinition;

public abstract class ConflictResolution {
    @Inject
    protected abstract ConfigurationContainer getConfigurations();

    abstract SetProperty<CapabilityDefinition> getDeactivatedResolutionStrategies();

    public void deactivateResolutionStrategy(CapabilityDefinition capability) {
        this.getDeactivatedResolutionStrategies().add((Object)capability);
    }

    public void deactivateResolutionStrategy(String capability) {
        Optional<CapabilityDefinition> definition = Arrays.stream(CapabilityDefinition.values()).filter(c -> capability.equals(c.getCapability())).findFirst();
        definition.ifPresent(c -> this.getDeactivatedResolutionStrategies().add((Object)c));
    }

    public void selectHighestVersion(CapabilityDefinition capability) {
        this.deactivateResolutionStrategy(capability);
        this.doSelectHighestVersion(capability.getCapability());
    }

    public void selectHighestVersion(String capability) {
        this.deactivateResolutionStrategy(capability);
        this.doSelectHighestVersion(capability);
    }

    public void select(CapabilityDefinition capability, String module) {
        this.deactivateResolutionStrategy(capability);
        this.doSelect(capability.getCapability(), module, false);
    }

    public void select(String capability, String module) {
        this.deactivateResolutionStrategy(capability);
        this.doSelect(capability, module, false);
    }

    public void selectLenient(CapabilityDefinition capability, String module) {
        this.deactivateResolutionStrategy(capability);
        this.doSelect(capability.getCapability(), module, true);
    }

    private void selectLenient(String capability, String module) {
        this.deactivateResolutionStrategy(capability);
        this.doSelect(capability, module, true);
    }

    private void doSelectHighestVersion(String capability) {
        this.getConfigurations().all(conf -> conf.getResolutionStrategy().getCapabilitiesResolution().withCapability((Object)capability, CapabilityResolutionDetails::selectHighestVersion));
    }

    private void doSelect(String capability, String module, boolean lenient) {
        String group = module.split(":")[0];
        String name = module.split(":")[1];
        this.getConfigurations().all(conf -> conf.getResolutionStrategy().getCapabilitiesResolution().withCapability((Object)capability, c -> {
            for (ComponentVariantIdentifier candidate : c.getCandidates()) {
                ComponentIdentifier id = candidate.getId();
                if (!(id instanceof ModuleComponentIdentifier) || !((ModuleComponentIdentifier)id).getGroup().equals(group) || !((ModuleComponentIdentifier)id).getModule().equals(name)) continue;
                c.select(candidate);
                return;
            }
            if (lenient && !c.getCandidates().isEmpty()) {
                c.select((ComponentVariantIdentifier)c.getCandidates().get(0));
            }
        }));
    }
}

