/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.jvm.dependency.conflict.resolution;

import java.util.Collections;
import javax.inject.Inject;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.attributes.java.TargetJvmEnvironment;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.util.GradleVersion;

public abstract class ConsistentResolution {
    private final SourceSetContainer sourceSets;

    @Inject
    public ConsistentResolution(SourceSetContainer sourceSets) {
        this.sourceSets = sourceSets;
    }

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ConfigurationContainer getConfigurations();

    @Inject
    protected abstract DependencyHandler getDependencies();

    public Configuration providesVersions(String versionProvidingProject) {
        Configuration mainRuntimeClasspath = this.maybeCreateMainRuntimeClasspathConfiguration();
        this.getDependencies().add(mainRuntimeClasspath.getName(), (Object)this.createDependency(versionProvidingProject));
        return mainRuntimeClasspath;
    }

    public void platform(String platform) {
        Configuration internal = this.maybeCreateInternalConfiguration();
        internal.withDependencies(d -> {
            Dependency platformDependency = this.getDependencies().platform((Object)this.createDependency(platform));
            d.add((Object)platformDependency);
        });
        this.sourceSets.configureEach(sourceSet -> {
            ConfigurationContainer configurations = this.getConfigurations();
            configurations.getByName(sourceSet.getRuntimeClasspathConfigurationName()).extendsFrom(new Configuration[]{internal});
            configurations.getByName(sourceSet.getCompileClasspathConfigurationName()).extendsFrom(new Configuration[]{internal});
            configurations.getByName(sourceSet.getAnnotationProcessorConfigurationName()).extendsFrom(new Configuration[]{internal});
        });
    }

    private Configuration maybeCreateMainRuntimeClasspathConfiguration() {
        Configuration existing = (Configuration)this.getConfigurations().findByName("mainRuntimeClasspath");
        if (existing != null) {
            return existing;
        }
        Configuration mainRuntimeClasspath = (Configuration)this.getConfigurations().create("mainRuntimeClasspath", c -> {
            ObjectFactory objects = this.getObjects();
            c.setCanBeResolved(true);
            c.setCanBeConsumed(false);
            c.extendsFrom(new Configuration[]{this.maybeCreateInternalConfiguration()});
            c.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)objects.named(Usage.class, "java-runtime")));
            c.getAttributes().attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)objects.named(Category.class, "library")));
            c.getAttributes().attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)objects.named(LibraryElements.class, "jar")));
            c.getAttributes().attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)objects.named(Bundling.class, "external")));
            if (GradleVersion.current().compareTo(GradleVersion.version((String)"7.0")) >= 0) {
                c.getAttributes().attribute(TargetJvmEnvironment.TARGET_JVM_ENVIRONMENT_ATTRIBUTE, (Object)((TargetJvmEnvironment)objects.named(TargetJvmEnvironment.class, "standard-jvm")));
            }
        });
        this.sourceSets.configureEach(sourceSet -> {
            ConfigurationContainer configurations = this.getConfigurations();
            Configuration runtime = configurations.getByName(sourceSet.getRuntimeClasspathConfigurationName());
            Configuration compile = configurations.getByName(sourceSet.getCompileClasspathConfigurationName());
            Configuration processor = configurations.getByName(sourceSet.getAnnotationProcessorConfigurationName());
            runtime.shouldResolveConsistentlyWith(mainRuntimeClasspath);
            compile.shouldResolveConsistentlyWith(runtime);
            processor.shouldResolveConsistentlyWith(runtime);
        });
        return mainRuntimeClasspath;
    }

    private Configuration maybeCreateInternalConfiguration() {
        Configuration internal = (Configuration)this.getConfigurations().findByName("internal");
        if (internal != null) {
            return internal;
        }
        return (Configuration)this.getConfigurations().create("internal", c -> {
            c.setCanBeResolved(false);
            c.setCanBeConsumed(false);
        });
    }

    private Dependency createDependency(String project) {
        boolean isProjectInBuild = project.startsWith(":");
        return this.getDependencies().create(isProjectInBuild ? this.getDependencies().project(Collections.singletonMap("path", project)) : project);
    }
}

