/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.jvm.dependency.conflict.resolution;

import org.gradle.api.Project;
import org.gradle.api.initialization.resolve.RulesMode;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradlex.jvm.dependency.conflict.detection.JvmDependencyConflictDetectionPlugin;

final class JvmDependencyConflictDetectionPluginApplication {
    private static final String PLUGIN_ID = "org.gradlex.jvm-dependency-conflict-detection";
    private final Project project;

    static JvmDependencyConflictDetectionPluginApplication of(Project project) {
        return new JvmDependencyConflictDetectionPluginApplication(project);
    }

    private JvmDependencyConflictDetectionPluginApplication(Project project) {
        this.project = project;
    }

    void handleRulesMode() {
        boolean baseAppliedViaSettings = this.isBaseAppliedViaSettings();
        RulesMode rulesMode = this.getRulesMode();
        String settingsFileName = this.getSettings().getSettingsScript().getFileName();
        switch (rulesMode) {
            case PREFER_PROJECT: {
                this.project.getPlugins().apply(JvmDependencyConflictDetectionPlugin.class);
                break;
            }
            case PREFER_SETTINGS: 
            case FAIL_ON_PROJECT_RULES: {
                if (baseAppliedViaSettings) break;
                throw new IllegalStateException("RulesMode is set to " + rulesMode + " in " + settingsFileName + " but the '" + PLUGIN_ID + "' plugin was not applied via settings. As a result this plugin will not work. Fix this problem by either changing dependencyResolutionManagement.rulesMode to PREFER_PROJECT or by applying '" + PLUGIN_ID + "' as a settings plugin in " + settingsFileName + ".");
            }
            default: {
                throw new IllegalStateException("Unknown RulesMode value '" + rulesMode + "'");
            }
        }
    }

    private boolean isBaseAppliedViaSettings() {
        return this.getSettings().getPlugins().hasPlugin(JvmDependencyConflictDetectionPlugin.class);
    }

    private RulesMode getRulesMode() {
        return (RulesMode)this.getSettings().getDependencyResolutionManagement().getRulesMode().get();
    }

    private SettingsInternal getSettings() {
        return ((GradleInternal)this.project.getGradle()).getSettings();
    }
}

