/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.jvm.dependency.conflict.resolution;

import java.util.Optional;
import java.util.Set;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.CapabilitiesResolution;
import org.gradle.api.artifacts.CapabilityResolutionDetails;
import org.gradle.api.artifacts.ComponentVariantIdentifier;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.plugins.JvmEcosystemPlugin;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradlex.jvm.dependency.conflict.detection.rules.CapabilityDefinition;
import org.gradlex.jvm.dependency.conflict.resolution.DefaultResolutionStrategy;
import org.gradlex.jvm.dependency.conflict.resolution.JvmDependencyConflictDetectionPluginApplication;
import org.gradlex.jvm.dependency.conflict.resolution.JvmDependencyConflictsExtension;

public abstract class JvmDependencyConflictResolutionPlugin
implements Plugin<Project> {
    public static final String MAIN_RUNTIME_CLASSPATH_CONFIGURATION_NAME = "mainRuntimeClasspath";
    public static final String INTERNAL_CONFIGURATION_NAME = "internal";

    public void apply(Project project) {
        JvmDependencyConflictDetectionPluginApplication.of(project).handleRulesMode();
        project.getPlugins().apply(JvmEcosystemPlugin.class);
        JvmDependencyConflictsExtension jvmDependencyConflicts = (JvmDependencyConflictsExtension)project.getExtensions().create("jvmDependencyConflicts", JvmDependencyConflictsExtension.class, new Object[]{project.getExtensions().getByType(SourceSetContainer.class)});
        this.configureResolutionStrategies(project.getConfigurations(), jvmDependencyConflicts);
    }

    private void configureResolutionStrategies(ConfigurationContainer configurations, JvmDependencyConflictsExtension jvmDependencyConflicts) {
        configurations.all(configuration -> {
            for (CapabilityDefinition definition : CapabilityDefinition.values()) {
                this.defineStrategy(definition, (Configuration)configuration, jvmDependencyConflicts);
            }
        });
    }

    private void defineStrategy(CapabilityDefinition definition, Configuration configuration, JvmDependencyConflictsExtension jvmDependencyConflicts) {
        CapabilitiesResolution resolution = configuration.getResolutionStrategy().getCapabilitiesResolution();
        resolution.withCapability((Object)definition.getCapability(), details -> {
            if (!((Set)jvmDependencyConflicts.getConflictResolution().getDeactivatedResolutionStrategies().get()).contains((Object)definition)) {
                if (definition.getDefaultStrategy() == DefaultResolutionStrategy.HIGHEST_VERSION) {
                    details.selectHighestVersion();
                } else if (definition.getDefaultStrategy() == DefaultResolutionStrategy.FIRST_MODULE) {
                    this.select((CapabilityResolutionDetails)details, definition.getModules().get(0));
                }
            }
        });
    }

    private void select(CapabilityResolutionDetails details, String moduleGA) {
        Optional<ComponentVariantIdentifier> module = details.getCandidates().stream().filter(c -> {
            if (c.getId() instanceof ModuleComponentIdentifier) {
                return ((ModuleComponentIdentifier)c.getId()).getModuleIdentifier().toString().equals(moduleGA);
            }
            return false;
        }).findFirst();
        module.ifPresent(arg_0 -> ((CapabilityResolutionDetails)details).select(arg_0));
    }
}

