/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.jvm.dependency.conflict.resolution;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.CapabilitiesResolution;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradlex.jvm.dependency.conflict.detection.rules.CapabilityDefinition;
import org.gradlex.jvm.dependency.conflict.detection.rules.logging.LoggingModuleIdentifiers;
import org.gradlex.jvm.dependency.conflict.resolution.Slf4JEnforcementSubstitutionsUsing;

public abstract class Logging {
    @Inject
    protected abstract DependencyHandler getDependencies();

    @Inject
    protected abstract ConfigurationContainer getConfigurations();

    public void selectSlf4JBinding(Object dependencyNotation) {
        ExternalDependency dependency = this.validateNotation(dependencyNotation);
        String because = "Logging capabilities plugin selected Slf4J binding";
        if (LoggingModuleIdentifiers.SLF4J_LOG4J12.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(CapabilityDefinition.SLF4J_VS_LOG4J.getCapability(), dependency, because);
            this.selectCapabilityConflict(CapabilityDefinition.SLF4J_IMPL.getCapability(), dependency, because);
        } else if (LoggingModuleIdentifiers.SLF4J_JDK14.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(CapabilityDefinition.SLF4J_VS_JUL.getCapability(), dependency, because);
            this.selectCapabilityConflict(CapabilityDefinition.SLF4J_IMPL.getCapability(), dependency, because);
        } else if (LoggingModuleIdentifiers.SLF4J_JCL.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(CapabilityDefinition.SLF4J_VS_JCL.getCapability(), dependency, because);
            this.selectCapabilityConflict(CapabilityDefinition.SLF4J_IMPL.getCapability(), dependency, because);
        } else if (LoggingModuleIdentifiers.LOG4J_SLF4J_IMPL.matches((Dependency)dependency) || LoggingModuleIdentifiers.LOG4J_SLF4J2_IMPL.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(CapabilityDefinition.LOG4J2_VS_SLF4J.getCapability(), dependency, because);
            this.selectCapabilityConflict(CapabilityDefinition.SLF4J_IMPL.getCapability(), dependency, because);
            this.selectCapabilityConflict(CapabilityDefinition.LOG4J2_IMPL.getCapability(), this.validateNotation(LoggingModuleIdentifiers.LOG4J_CORE.moduleId), because);
        } else if (LoggingModuleIdentifiers.LOGBACK_CLASSIC.matches((Dependency)dependency) || LoggingModuleIdentifiers.SLF4J_SIMPLE.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(CapabilityDefinition.SLF4J_IMPL.getCapability(), dependency, because);
        } else {
            throw new IllegalArgumentException("Provided dependency '" + dependency + "' is not a valid Slf4J binding");
        }
    }

    public void selectSlf4JBinding(String configurationName, Object dependencyNotation) {
        ExternalDependency dependency = this.validateNotation(dependencyNotation);
        String because = "Logging capabilities plugin selected Slf4J binding";
        if (LoggingModuleIdentifiers.SLF4J_LOG4J12.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.SLF4J_VS_LOG4J.getCapability(), dependency, because);
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.SLF4J_IMPL.getCapability(), dependency, because);
        } else if (LoggingModuleIdentifiers.SLF4J_JDK14.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.SLF4J_VS_JUL.getCapability(), dependency, because);
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.SLF4J_IMPL.getCapability(), dependency, because);
        } else if (LoggingModuleIdentifiers.SLF4J_JCL.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.SLF4J_VS_JCL.getCapability(), dependency, because);
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.SLF4J_IMPL.getCapability(), dependency, because);
        } else if (LoggingModuleIdentifiers.LOG4J_SLF4J_IMPL.matches((Dependency)dependency) || LoggingModuleIdentifiers.LOG4J_SLF4J2_IMPL.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.LOG4J2_VS_SLF4J.getCapability(), dependency, because);
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.SLF4J_IMPL.getCapability(), dependency, because);
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.LOG4J2_IMPL.getCapability(), this.validateNotation(LoggingModuleIdentifiers.LOG4J_CORE.moduleId), because);
        } else if (LoggingModuleIdentifiers.LOGBACK_CLASSIC.matches((Dependency)dependency) || LoggingModuleIdentifiers.SLF4J_SIMPLE.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.SLF4J_IMPL.getCapability(), dependency, because);
        } else {
            throw new IllegalArgumentException("Provided dependency '" + dependency + "' is not a valid Slf4J binding");
        }
    }

    public void selectLog4J2Implementation(Object dependencyNotation) {
        ExternalDependency dependency = this.validateNotation(dependencyNotation);
        String because = "Logging capabilities plugin selected Log4J2 implementation";
        if (LoggingModuleIdentifiers.LOG4J_CORE.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(CapabilityDefinition.LOG4J2_IMPL.getCapability(), dependency, because);
        } else if (LoggingModuleIdentifiers.LOG4J_TO_SLF4J.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(CapabilityDefinition.LOG4J2_IMPL.getCapability(), dependency, because);
        } else {
            throw new IllegalArgumentException("Provided dependency '" + dependency + "' is not a valid Log4J2 implementation");
        }
    }

    public void selectLog4J2Implementation(String configurationName, Object dependencyNotation) {
        ExternalDependency dependency = this.validateNotation(dependencyNotation);
        String because = "Logging capabilities plugin selected Log4J2 implementation";
        if (LoggingModuleIdentifiers.LOG4J_CORE.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.LOG4J2_IMPL.getCapability(), dependency, because);
        } else if (LoggingModuleIdentifiers.LOG4J_TO_SLF4J.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.LOG4J2_IMPL.getCapability(), dependency, because);
        } else {
            throw new IllegalArgumentException("Provided dependency '" + dependency + "' is not a valid Log4J2 implementation");
        }
    }

    public void selectLog4J12Implementation(Object dependencyNotation) {
        ExternalDependency dependency = this.validateNotation(dependencyNotation);
        String because = "Logging capabilities plugin selected Log4J implementation";
        if (LoggingModuleIdentifiers.LOG4J_OVER_SLF4J.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(CapabilityDefinition.SLF4J_VS_LOG4J2_FOR_LOG4J.getCapability(), dependency, because);
            this.selectCapabilityConflict(CapabilityDefinition.SLF4J_VS_LOG4J.getCapability(), dependency, because);
        } else if (LoggingModuleIdentifiers.LOG4J12API.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(CapabilityDefinition.SLF4J_VS_LOG4J2_FOR_LOG4J.getCapability(), dependency, because);
        } else if (LoggingModuleIdentifiers.LOG4J.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(CapabilityDefinition.SLF4J_VS_LOG4J2_FOR_LOG4J.getCapability(), dependency, because);
        } else if (LoggingModuleIdentifiers.SLF4J_LOG4J12.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(CapabilityDefinition.SLF4J_VS_LOG4J.getCapability(), dependency, because);
        } else {
            throw new IllegalArgumentException("Provided dependency '" + dependency + "' is not a valid Log4J implementation");
        }
    }

    public void selectLog4J12Implementation(String configurationName, Object dependencyNotation) {
        ExternalDependency dependency = this.validateNotation(dependencyNotation);
        String because = "Logging capabilities plugin selected Log4J implementation";
        if (LoggingModuleIdentifiers.LOG4J_OVER_SLF4J.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.SLF4J_VS_LOG4J2_FOR_LOG4J.getCapability(), dependency, because);
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.SLF4J_VS_LOG4J.getCapability(), dependency, because);
        } else if (LoggingModuleIdentifiers.LOG4J12API.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.SLF4J_VS_LOG4J2_FOR_LOG4J.getCapability(), dependency, because);
        } else if (LoggingModuleIdentifiers.LOG4J.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.SLF4J_VS_LOG4J2_FOR_LOG4J.getCapability(), dependency, because);
        } else if (LoggingModuleIdentifiers.SLF4J_LOG4J12.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.SLF4J_VS_LOG4J.getCapability(), dependency, because);
        } else {
            throw new IllegalArgumentException("Provided dependency '" + dependency + "' is not a valid Log4J implementation");
        }
    }

    public void selectJulDelegation(Object dependencyNotation) {
        ExternalDependency dependency = this.validateNotation(dependencyNotation);
        String because = "Logging capabilities plugin selected JUL delegation";
        if (LoggingModuleIdentifiers.JUL_TO_SLF4J.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(CapabilityDefinition.SLF4J_VS_LOG4J2_FOR_JUL.getCapability(), dependency, because);
            this.selectCapabilityConflict(CapabilityDefinition.SLF4J_VS_JUL.getCapability(), dependency, because);
        } else if (LoggingModuleIdentifiers.SLF4J_JDK14.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(CapabilityDefinition.SLF4J_VS_JUL.getCapability(), dependency, because);
        } else if (LoggingModuleIdentifiers.LOG4J_JUL.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(CapabilityDefinition.SLF4J_VS_LOG4J2_FOR_JUL.getCapability(), dependency, because);
        } else {
            throw new IllegalArgumentException("Provided dependency '" + dependency + "' is not a valid JUL delegation");
        }
    }

    public void selectJulDelegation(String configurationName, Object dependencyNotation) {
        ExternalDependency dependency = this.validateNotation(dependencyNotation);
        String because = "Logging capabilities plugin selected JUL delegation";
        if (LoggingModuleIdentifiers.JUL_TO_SLF4J.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.SLF4J_VS_LOG4J2_FOR_JUL.getCapability(), dependency, because);
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.SLF4J_VS_JUL.getCapability(), dependency, because);
        } else if (LoggingModuleIdentifiers.SLF4J_JDK14.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.SLF4J_VS_JUL.getCapability(), dependency, because);
        } else if (LoggingModuleIdentifiers.LOG4J_JUL.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.SLF4J_VS_LOG4J2_FOR_JUL.getCapability(), dependency, because);
        } else {
            throw new IllegalArgumentException("Provided dependency '" + dependency + "' is not a valid JUL delegation");
        }
    }

    public void selectJCLImplementation(Object dependencyNotation) {
        ExternalDependency dependency = this.validateNotation(dependencyNotation);
        String because = "Logging capabilities plugin selected JCL implementation";
        if (LoggingModuleIdentifiers.JCL_OVER_SLF4J.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(CapabilityDefinition.COMMONS_LOGGING_IMPL.getCapability(), dependency, because);
            this.selectCapabilityConflict(CapabilityDefinition.SLF4J_VS_JCL.getCapability(), dependency, because);
            this.selectCapabilityConflict(CapabilityDefinition.SLF4J_VS_LOG4J2_FOR_JCL.getCapability(), dependency, because);
        } else if (LoggingModuleIdentifiers.COMMONS_LOGGING.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(CapabilityDefinition.COMMONS_LOGGING_IMPL.getCapability(), dependency, because);
        } else if (LoggingModuleIdentifiers.SLF4J_JCL.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(CapabilityDefinition.SLF4J_VS_JCL.getCapability(), dependency, because);
        } else if (LoggingModuleIdentifiers.LOG4J_JCL.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(CapabilityDefinition.SLF4J_VS_LOG4J2_FOR_JCL.getCapability(), dependency, because);
            ExternalDependency commonsLogging = this.validateNotation(LoggingModuleIdentifiers.COMMONS_LOGGING.moduleId);
            this.selectCapabilityConflict(CapabilityDefinition.COMMONS_LOGGING_IMPL.getCapability(), commonsLogging, because);
        } else {
            throw new IllegalArgumentException("Provided dependency '" + dependency + "' is not a valid JCL implementation");
        }
    }

    public void selectJCLImplementation(String configurationName, Object dependencyNotation) {
        ExternalDependency dependency = this.validateNotation(dependencyNotation);
        String because = "Logging capabilities plugin selected JCL implementation";
        if (LoggingModuleIdentifiers.JCL_OVER_SLF4J.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.COMMONS_LOGGING_IMPL.getCapability(), dependency, because);
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.SLF4J_VS_JCL.getCapability(), dependency, because);
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.SLF4J_VS_LOG4J2_FOR_JCL.getCapability(), dependency, because);
        } else if (LoggingModuleIdentifiers.COMMONS_LOGGING.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.COMMONS_LOGGING_IMPL.getCapability(), dependency, because);
        } else if (LoggingModuleIdentifiers.SLF4J_JCL.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.SLF4J_VS_JCL.getCapability(), dependency, because);
        } else if (LoggingModuleIdentifiers.LOG4J_JCL.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.SLF4J_VS_LOG4J2_FOR_JCL.getCapability(), dependency, because);
            ExternalDependency commonsLogging = this.validateNotation(LoggingModuleIdentifiers.COMMONS_LOGGING.moduleId);
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.COMMONS_LOGGING_IMPL.getCapability(), commonsLogging, because);
        } else {
            throw new IllegalArgumentException("Provided dependency '" + dependency + "' is not a valid JCL implementation");
        }
    }

    public void selectSlf4JLog4J2Interaction(Object dependencyNotation) {
        ExternalDependency dependency = this.validateNotation(dependencyNotation);
        String because = "Logging capabilities plugin selected Slf4J Log4J 2 interaction";
        if (LoggingModuleIdentifiers.LOG4J_TO_SLF4J.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(CapabilityDefinition.LOG4J2_VS_SLF4J.getCapability(), dependency, because);
            this.selectCapabilityConflict(CapabilityDefinition.LOG4J2_IMPL.getCapability(), dependency, because);
        } else if (LoggingModuleIdentifiers.LOG4J_SLF4J_IMPL.matches((Dependency)dependency) || LoggingModuleIdentifiers.LOG4J_SLF4J2_IMPL.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(CapabilityDefinition.SLF4J_IMPL.getCapability(), dependency, because);
            this.selectCapabilityConflict(CapabilityDefinition.LOG4J2_VS_SLF4J.getCapability(), dependency, because);
        } else {
            throw new IllegalArgumentException("Provided dependency '" + dependency + "' is not a valid Slf4J / Log4J 2 interaction");
        }
    }

    public void selectSlf4JLog4J2Interaction(String configurationName, Object dependencyNotation) {
        ExternalDependency dependency = this.validateNotation(dependencyNotation);
        String because = "Logging capabilities plugin selected Slf4J Log4J 2 interaction";
        if (LoggingModuleIdentifiers.LOG4J_TO_SLF4J.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.LOG4J2_VS_SLF4J.getCapability(), dependency, because);
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.LOG4J2_IMPL.getCapability(), dependency, because);
        } else if (LoggingModuleIdentifiers.LOG4J_SLF4J_IMPL.matches((Dependency)dependency) || LoggingModuleIdentifiers.LOG4J_SLF4J2_IMPL.matches((Dependency)dependency)) {
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.SLF4J_IMPL.getCapability(), dependency, because);
            this.selectCapabilityConflict(configurationName, CapabilityDefinition.LOG4J2_VS_SLF4J.getCapability(), dependency, because);
        } else {
            throw new IllegalArgumentException("Provided dependency '" + dependency + "' is not a valid Slf4J / Log4J 2 interaction");
        }
    }

    public void enforceLogback() {
        this.selectSlf4JBinding(LoggingModuleIdentifiers.LOGBACK_CLASSIC.moduleId);
        this.enforceSlf4JImplementation();
    }

    public void enforceLogback(String configurationName) {
        this.selectSlf4JBinding(configurationName, LoggingModuleIdentifiers.LOGBACK_CLASSIC.moduleId);
        this.enforceSlf4JImplementation(configurationName);
    }

    public void enforceSlf4JSimple() {
        this.selectSlf4JBinding(LoggingModuleIdentifiers.SLF4J_SIMPLE.moduleId);
        this.enforceSlf4JImplementation();
    }

    public void enforceSlf4JSimple(String configurationName) {
        this.selectSlf4JBinding(configurationName, LoggingModuleIdentifiers.SLF4J_SIMPLE.moduleId);
        this.enforceSlf4JImplementation(configurationName);
    }

    public void enforceLog4J2() {
        this.selectLog4J2Implementation(LoggingModuleIdentifiers.LOG4J_CORE.moduleId);
        this.selectSlf4JLog4J2Interaction(LoggingModuleIdentifiers.LOG4J_SLF4J_IMPL.moduleId);
        this.selectJulDelegation(LoggingModuleIdentifiers.LOG4J_JUL.moduleId);
        this.selectJCLImplementation(LoggingModuleIdentifiers.LOG4J_JCL.moduleId);
        this.selectLog4J12Implementation(LoggingModuleIdentifiers.LOG4J12API.moduleId);
    }

    public void enforceLog4J2(String configurationName) {
        this.selectLog4J2Implementation(configurationName, LoggingModuleIdentifiers.LOG4J_CORE.moduleId);
        this.selectSlf4JLog4J2Interaction(configurationName, LoggingModuleIdentifiers.LOG4J_SLF4J_IMPL.moduleId);
        this.selectJulDelegation(configurationName, LoggingModuleIdentifiers.LOG4J_JUL.moduleId);
        this.selectJCLImplementation(configurationName, LoggingModuleIdentifiers.LOG4J_JCL.moduleId);
        this.selectLog4J12Implementation(configurationName, LoggingModuleIdentifiers.LOG4J12API.moduleId);
    }

    private void enforceSlf4JImplementation() {
        this.selectLog4J12Implementation(LoggingModuleIdentifiers.LOG4J_OVER_SLF4J.moduleId);
        this.selectJulDelegation(LoggingModuleIdentifiers.JUL_TO_SLF4J.moduleId);
        this.selectJCLImplementation(LoggingModuleIdentifiers.JCL_OVER_SLF4J.moduleId);
        this.selectSlf4JLog4J2Interaction(LoggingModuleIdentifiers.LOG4J_TO_SLF4J.moduleId);
        this.selectLog4J2Implementation(LoggingModuleIdentifiers.LOG4J_TO_SLF4J.moduleId);
        this.getConfigurations().all((Action)new Slf4JEnforcementSubstitutionsUsing());
    }

    private void enforceSlf4JImplementation(String configurationName) {
        this.selectLog4J12Implementation(configurationName, LoggingModuleIdentifiers.LOG4J_OVER_SLF4J.moduleId);
        this.selectJulDelegation(configurationName, LoggingModuleIdentifiers.JUL_TO_SLF4J.moduleId);
        this.selectJCLImplementation(configurationName, LoggingModuleIdentifiers.JCL_OVER_SLF4J.moduleId);
        this.selectSlf4JLog4J2Interaction(configurationName, LoggingModuleIdentifiers.LOG4J_TO_SLF4J.moduleId);
        this.selectLog4J2Implementation(configurationName, LoggingModuleIdentifiers.LOG4J_TO_SLF4J.moduleId);
        this.getConfigurations().matching(conf -> conf.getName().equals(configurationName)).all((Action)new Slf4JEnforcementSubstitutionsUsing());
    }

    private ExternalDependency validateNotation(Object dependencyNotation) {
        Dependency dependency = this.getDependencies().create(dependencyNotation);
        if (dependency instanceof ExternalDependency) {
            return (ExternalDependency)dependency;
        }
        throw new IllegalArgumentException("Provided notation '" + dependencyNotation + "' cannot be converted to an ExternalDependency");
    }

    private void selectCapabilityConflict(String configuration, String capabilityId, ExternalDependency target, String because) {
        this.getConfigurations().matching(conf -> conf.getName().equals(configuration)).all(conf -> conf.getResolutionStrategy().capabilitiesResolution(this.getCapabilitiesResolutionAction(capabilityId, target, because)));
    }

    private void selectCapabilityConflict(String capabilityId, ExternalDependency target, String because) {
        this.getConfigurations().all(conf -> conf.getResolutionStrategy().capabilitiesResolution(this.getCapabilitiesResolutionAction(capabilityId, target, because)));
    }

    private Action<CapabilitiesResolution> getCapabilitiesResolutionAction(String capabilityId, ExternalDependency target, String because) {
        return resolution -> resolution.withCapability((Object)capabilityId, details -> details.getCandidates().stream().filter(candidate -> {
            ComponentIdentifier id = candidate.getId();
            if (!(id instanceof ModuleComponentIdentifier)) {
                return false;
            }
            ModuleComponentIdentifier moduleId = (ModuleComponentIdentifier)id;
            return moduleId.getGroup().equals(target.getGroup()) && moduleId.getModule().equals(target.getName());
        }).findFirst().ifPresent(candidate -> details.select(candidate).because(because)));
    }
}

