/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.jvm.dependency.conflict.resolution;

import java.util.Arrays;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.model.ObjectFactory;
import org.gradlex.jvm.dependency.conflict.resolution.PatchModule;
import org.gradlex.jvm.dependency.conflict.resolution.rules.AddAlignmentConstraintsMetadataRule;
import org.gradlex.jvm.dependency.conflict.resolution.rules.AddBomDependencyMetadataRule;

public abstract class Patch {
    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract DependencyHandler getDependencies();

    public PatchModule module(String module) {
        return (PatchModule)this.getObjects().newInstance(PatchModule.class, new Object[]{module});
    }

    public void module(String module, Action<PatchModule> action) {
        action.execute((Object)((PatchModule)this.getObjects().newInstance(PatchModule.class, new Object[]{module})));
    }

    public void alignWithBom(String bom, String ... modules) {
        for (String module : modules) {
            this.getDependencies().getComponents().withModule((Object)module, AddBomDependencyMetadataRule.class, r -> r.params(new Object[]{bom}));
        }
    }

    public void align(String ... modules) {
        for (String module : modules) {
            this.getDependencies().getComponents().withModule((Object)module, AddAlignmentConstraintsMetadataRule.class, r -> r.params(new Object[]{Arrays.asList(modules)}));
        }
    }
}

