/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.jvm.dependency.conflict.resolution;

import java.util.Arrays;
import javax.inject.Inject;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradlex.jvm.dependency.conflict.detection.rules.CapabilityDefinition;
import org.gradlex.jvm.dependency.conflict.resolution.rules.AddApiDependencyMetadataRule;
import org.gradlex.jvm.dependency.conflict.resolution.rules.AddCapabilityMetadataRule;
import org.gradlex.jvm.dependency.conflict.resolution.rules.AddCompileOnlyApiDependencyMetadataRule;
import org.gradlex.jvm.dependency.conflict.resolution.rules.AddFeatureMetadataRule;
import org.gradlex.jvm.dependency.conflict.resolution.rules.AddRuntimeOnlyDependencyMetadataRule;
import org.gradlex.jvm.dependency.conflict.resolution.rules.AddTargetPlatformVariantsMetadataRule;
import org.gradlex.jvm.dependency.conflict.resolution.rules.ComponentStatusRule;
import org.gradlex.jvm.dependency.conflict.resolution.rules.ReduceToCompileOnlyApiDependencyMetadataRule;
import org.gradlex.jvm.dependency.conflict.resolution.rules.ReduceToRuntimeOnlyDependencyMetadataRule;
import org.gradlex.jvm.dependency.conflict.resolution.rules.RemoveCapabilityMetadataRule;
import org.gradlex.jvm.dependency.conflict.resolution.rules.RemoveDependencyMetadataRule;

public abstract class PatchModule {
    private final String module;

    @Inject
    protected abstract DependencyHandler getDependencies();

    @Inject
    public PatchModule(String module) {
        this.module = module;
    }

    public void addApiDependency(String dependency) {
        this.getDependencies().getComponents().withModule((Object)this.module, AddApiDependencyMetadataRule.class, r -> r.params(new Object[]{dependency}));
    }

    public void addRuntimeOnlyDependency(String dependency) {
        this.getDependencies().getComponents().withModule((Object)this.module, AddRuntimeOnlyDependencyMetadataRule.class, r -> r.params(new Object[]{dependency}));
    }

    public void addCompileOnlyApiDependency(String dependency) {
        this.getDependencies().getComponents().withModule((Object)this.module, AddCompileOnlyApiDependencyMetadataRule.class, r -> r.params(new Object[]{dependency}));
    }

    public void removeDependency(String dependency) {
        this.getDependencies().getComponents().withModule((Object)this.module, RemoveDependencyMetadataRule.class, r -> r.params(new Object[]{dependency}));
    }

    public void reduceToRuntimeOnlyDependency(String dependency) {
        this.getDependencies().getComponents().withModule((Object)this.module, ReduceToRuntimeOnlyDependencyMetadataRule.class, r -> r.params(new Object[]{dependency}));
    }

    public void reduceToCompileOnlyApiDependency(String dependency) {
        this.getDependencies().getComponents().withModule((Object)this.module, ReduceToCompileOnlyApiDependencyMetadataRule.class, r -> r.params(new Object[]{dependency}));
    }

    public void addCapability(CapabilityDefinition capability) {
        this.addCapability(capability.getCapability());
    }

    public void addCapability(String capability) {
        this.getDependencies().getComponents().withModule((Object)this.module, AddCapabilityMetadataRule.class, r -> r.params(new Object[]{capability}));
    }

    public void removeCapability(CapabilityDefinition capability) {
        this.removeCapability(capability.getCapability());
    }

    public void removeCapability(String capability) {
        this.getDependencies().getComponents().withModule((Object)this.module, RemoveCapabilityMetadataRule.class, r -> r.params(new Object[]{capability}));
    }

    public void addFeature(String classifier) {
        this.getDependencies().getComponents().withModule((Object)this.module, AddFeatureMetadataRule.class, r -> r.params(new Object[]{classifier}));
    }

    public void addTargetPlatformVariant(String classifier, String operatingSystem, String architecture) {
        this.getDependencies().getComponents().withModule((Object)this.module, AddTargetPlatformVariantsMetadataRule.class, r -> r.params(new Object[]{classifier, operatingSystem, architecture}));
    }

    public void setStatusToIntegration(String ... markerInVersion) {
        this.getDependencies().getComponents().withModule((Object)this.module, ComponentStatusRule.class, r -> r.params(new Object[]{Arrays.asList(markerInVersion)}));
    }
}

