/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.jvm.dependency.conflict.resolution.rules;

import javax.inject.Inject;
import org.gradle.api.artifacts.CacheableRule;
import org.gradle.api.artifacts.ComponentMetadataContext;
import org.gradle.api.artifacts.ComponentMetadataRule;
import org.gradle.api.artifacts.ModuleVersionIdentifier;

@CacheableRule
public abstract class AddFeatureMetadataRule
implements ComponentMetadataRule {
    private final String classifier;

    @Inject
    public AddFeatureMetadataRule(String classifier) {
        this.classifier = classifier;
    }

    public void execute(ComponentMetadataContext context) {
        AddFeatureMetadataRule.addFeatureVariant(context, this.classifier, "Compile", "compile");
        AddFeatureMetadataRule.addFeatureVariant(context, this.classifier, "Runtime", "runtime");
    }

    private static void addFeatureVariant(ComponentMetadataContext context, String classifier, String nameSuffix, String baseVariant) {
        ModuleVersionIdentifier id = context.getDetails().getId();
        String group = id.getGroup();
        String name = id.getName();
        String version = id.getVersion();
        context.getDetails().addVariant(classifier + nameSuffix, baseVariant, v -> {
            v.withCapabilities(c -> {
                c.removeCapability(group, name);
                c.addCapability(group, name + "-" + classifier, version);
            });
            v.withFiles(f -> {
                f.removeAllFiles();
                f.addFile(name + "-" + version + "-" + classifier + ".jar");
            });
        });
    }
}

