/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.jvm.dependency.conflict.resolution.rules;

import javax.inject.Inject;
import org.gradle.api.artifacts.CacheableRule;
import org.gradle.api.artifacts.ComponentMetadataContext;
import org.gradle.api.artifacts.ComponentMetadataDetails;
import org.gradle.api.artifacts.ComponentMetadataRule;
import org.gradle.api.artifacts.VariantMetadata;
import org.gradle.api.model.ObjectFactory;
import org.gradle.nativeplatform.MachineArchitecture;
import org.gradle.nativeplatform.OperatingSystemFamily;

@CacheableRule
public abstract class AddTargetPlatformVariantsMetadataRule
implements ComponentMetadataRule {
    private final String classifier;
    private final String operatingSystem;
    private final String architecture;

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    public AddTargetPlatformVariantsMetadataRule(String classifier, String operatingSystem, String architecture) {
        this.classifier = classifier;
        this.operatingSystem = operatingSystem;
        this.architecture = architecture;
    }

    public void execute(ComponentMetadataContext context) {
        ComponentMetadataDetails details = context.getDetails();
        if (this.classifier.isEmpty()) {
            details.withVariant("compile", this::configureAttributes);
            details.withVariant("runtime", this::configureAttributes);
        } else {
            this.addTargetPlatformVariant(details, "Compile", "compile");
            this.addTargetPlatformVariant(details, "Runtime", "runtime");
        }
    }

    private void addTargetPlatformVariant(ComponentMetadataDetails details, String nameSuffix, String baseVariant) {
        String name = details.getId().getName();
        String version = details.getId().getVersion();
        details.addVariant(this.classifier + nameSuffix, baseVariant, variant -> {
            this.configureAttributes((VariantMetadata)variant);
            variant.withFiles(files -> {
                files.removeAllFiles();
                files.addFile(name + "-" + version + "-" + this.classifier + ".jar");
            });
        });
    }

    private void configureAttributes(VariantMetadata variant) {
        variant.attributes(attributes -> {
            attributes.attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)((OperatingSystemFamily)this.getObjects().named(OperatingSystemFamily.class, this.operatingSystem)));
            attributes.attribute(MachineArchitecture.ARCHITECTURE_ATTRIBUTE, (Object)((MachineArchitecture)this.getObjects().named(MachineArchitecture.class, this.architecture)));
        });
    }
}

