/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.audit;

import com.google.common.base.Strings;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.graylog2.audit.AutoValue_AuditActor;
import org.graylog2.plugin.system.NodeId;

public abstract class AuditActor {
    private static final String URN_GRAYLOG_NODE = "urn:graylog:node:";
    private static final String URN_GRAYLOG_USER = "urn:graylog:user:";

    public abstract String urn();

    public static AuditActor user(@Nonnull String username) {
        if (Strings.isNullOrEmpty((String)username)) {
            throw new IllegalArgumentException("username must not be null or empty");
        }
        return new AutoValue_AuditActor(URN_GRAYLOG_USER + username);
    }

    public static AuditActor system(@Nonnull NodeId nodeId) {
        return new AutoValue_AuditActor(URN_GRAYLOG_NODE + Objects.requireNonNull(nodeId, "nodeId must not be null").toString());
    }
}

