/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bindings.providers;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.graylog2.plugin.security.PasswordAlgorithm;

public class DefaultPasswordAlgorithmProvider
implements Provider<PasswordAlgorithm> {
    private final PasswordAlgorithm defaultPasswordAlgorithm;

    @Inject
    public DefaultPasswordAlgorithmProvider(@Named(value="user_password_default_algorithm") String defaultPasswordAlgorithmName, Map<String, PasswordAlgorithm> passwordAlgorithms) {
        if (!passwordAlgorithms.containsKey(defaultPasswordAlgorithmName)) {
            throw new IllegalArgumentException("Invalid default password hashing specified in config. Found: " + defaultPasswordAlgorithmName + ". Valid options: " + passwordAlgorithms.keySet());
        }
        this.defaultPasswordAlgorithm = passwordAlgorithms.get(defaultPasswordAlgorithmName);
    }

    public PasswordAlgorithm get() {
        return this.defaultPasswordAlgorithm;
    }
}

