/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.graylog2.dashboards.widgets.WidgetCacheTime;
import org.graylog2.plugin.database.EmbeddedPersistable;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

public class DashboardWidget
implements EmbeddedPersistable {
    public static final String FIELD_ID = "id";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_CACHE_TIME = "cache_time";
    public static final String FIELD_CREATOR_USER_ID = "creator_user_id";
    public static final String FIELD_CONFIG = "config";
    private final String type;
    private final String id;
    private final TimeRange timeRange;
    private final Map<String, Object> config;
    private final String creatorUserId;
    private int cacheTime;
    private String description;

    protected DashboardWidget(String type, String id, TimeRange timeRange, String description, WidgetCacheTime cacheTime, Map<String, Object> config, String creatorUserId) {
        this.type = type;
        this.id = id;
        this.timeRange = timeRange;
        this.config = config;
        this.creatorUserId = creatorUserId;
        this.description = description;
        this.cacheTime = cacheTime.getCacheTime();
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCacheTime(int cacheTime) {
        this.cacheTime = cacheTime;
    }

    public int getCacheTime() {
        return this.cacheTime;
    }

    public TimeRange getTimeRange() {
        Preconditions.checkArgument((this.timeRange != null ? 1 : 0) != 0, (Object)"Invalid time range provided");
        return this.timeRange;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public String getCreatorUserId() {
        return this.creatorUserId;
    }

    @Override
    public Map<String, Object> getPersistedFields() {
        return ImmutableMap.builder().put((Object)FIELD_ID, (Object)this.id).put((Object)FIELD_TYPE, (Object)this.type).put((Object)FIELD_DESCRIPTION, (Object)this.description).put((Object)FIELD_CACHE_TIME, (Object)this.cacheTime).put((Object)FIELD_CREATOR_USER_ID, (Object)this.creatorUserId).put((Object)FIELD_CONFIG, this.getPersistedConfig()).build();
    }

    public Map<String, Object> getPersistedConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>(this.getConfig());
        config.put("timerange", this.getTimeRange().getPersistedConfig());
        return config;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DashboardWidget)) {
            return false;
        }
        DashboardWidget that = (DashboardWidget)o;
        return this.cacheTime == that.cacheTime && Objects.equals(this.type, that.type) && Objects.equals(this.id, that.id) && Objects.equals(this.timeRange, that.timeRange) && Objects.equals(this.config, that.config) && Objects.equals(this.creatorUserId, that.creatorUserId) && Objects.equals(this.description, that.description);
    }

    public final int hashCode() {
        return Objects.hash(this.type, this.id, this.timeRange, this.config, this.creatorUserId, this.cacheTime, this.description);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add(FIELD_TYPE, (Object)this.type).add(FIELD_ID, (Object)this.id).add("timeRange", (Object)this.timeRange).add(FIELD_CONFIG, this.config).add("creatorUserId", (Object)this.creatorUserId).add("cacheTime", this.cacheTime).add(FIELD_DESCRIPTION, (Object)this.description).toString();
    }

    public static class NoSuchWidgetTypeException
    extends Exception {
        public NoSuchWidgetTypeException() {
        }

        public NoSuchWidgetTypeException(String msg) {
            super(msg);
        }
    }
}

