/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets.strategies;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.graylog2.dashboards.widgets.InvalidWidgetConfigurationException;
import org.graylog2.indexer.results.TermsResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.plugin.dashboards.widgets.ComputationResult;
import org.graylog2.plugin.dashboards.widgets.WidgetStrategy;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

public class QuickvaluesWidgetStrategy
implements WidgetStrategy {
    private final String query;
    @Nullable
    private final String streamId;
    private final String field;
    private final Searches searches;
    private final TimeRange timeRange;

    @AssistedInject
    public QuickvaluesWidgetStrategy(Searches searches, @Assisted Map<String, Object> config, @Assisted TimeRange timeRange, @Assisted String widgetId) throws InvalidWidgetConfigurationException {
        this.searches = searches;
        this.timeRange = timeRange;
        if (!this.checkConfig(config)) {
            throw new InvalidWidgetConfigurationException("Missing or invalid widget configuration. Provided config was: " + config.toString());
        }
        this.query = (String)config.get("query");
        this.field = (String)config.get("field");
        this.streamId = (String)config.get("stream_id");
    }

    @Override
    public ComputationResult compute() {
        String filter = null;
        if (!Strings.isNullOrEmpty((String)this.streamId)) {
            filter = "streams:" + this.streamId;
        }
        TermsResult terms = this.searches.terms(this.field, 50, this.query, filter, this.timeRange);
        HashMap result = Maps.newHashMap();
        result.put("terms", terms.getTerms());
        result.put("total", terms.getTotal());
        result.put("other", terms.getOther());
        result.put("missing", terms.getMissing());
        return new ComputationResult(result, terms.tookMs());
    }

    private boolean checkConfig(Map<String, Object> config) {
        return config.containsKey("field");
    }

    public static interface Factory
    extends WidgetStrategy.Factory<QuickvaluesWidgetStrategy> {
        @Override
        public QuickvaluesWidgetStrategy create(Map<String, Object> var1, TimeRange var2, String var3);
    }
}

