/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets.strategies;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.HashMap;
import java.util.Map;
import org.graylog2.dashboards.widgets.strategies.SearchResultCountWidgetStrategy;
import org.graylog2.indexer.FieldTypeException;
import org.graylog2.indexer.results.FieldStatsResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.plugin.dashboards.widgets.ComputationResult;
import org.graylog2.plugin.dashboards.widgets.WidgetStrategy;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.joda.time.DateTime;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticalCountWidgetStrategy
extends SearchResultCountWidgetStrategy {
    private static final Logger log = LoggerFactory.getLogger(StatisticalCountWidgetStrategy.class);
    private final StatisticalFunction statsFunction;
    private final String field;
    private final String streamId;

    @AssistedInject
    public StatisticalCountWidgetStrategy(Searches searches, @Assisted Map<String, Object> config, @Assisted TimeRange timeRange, @Assisted String widgetId) {
        super(searches, config, timeRange, widgetId);
        this.field = (String)config.get("field");
        String statsFunction = (String)config.get("stats_function");
        this.statsFunction = "stddev".equals(statsFunction) ? StatisticalFunction.STANDARD_DEVIATION : StatisticalFunction.fromString(statsFunction);
        this.streamId = (String)config.get("stream_id");
    }

    private Number getStatisticalValue(FieldStatsResult fieldStatsResult) {
        switch (this.statsFunction) {
            case COUNT: {
                return fieldStatsResult.getCount();
            }
            case MEAN: {
                return fieldStatsResult.getMean();
            }
            case STANDARD_DEVIATION: {
                return fieldStatsResult.getStdDeviation();
            }
            case MIN: {
                return fieldStatsResult.getMin();
            }
            case MAX: {
                return fieldStatsResult.getMax();
            }
            case SUM: {
                return fieldStatsResult.getSum();
            }
            case VARIANCE: {
                return fieldStatsResult.getVariance();
            }
            case SUM_OF_SQUARES: {
                return fieldStatsResult.getSumOfSquares();
            }
            case CARDINALITY: {
                return fieldStatsResult.getCardinality();
            }
        }
        throw new IllegalArgumentException("Statistic function " + (Object)((Object)this.statsFunction) + " is not supported");
    }

    @Override
    public ComputationResult compute() {
        try {
            String filter = !Strings.isNullOrEmpty((String)this.streamId) ? "streams:" + this.streamId : null;
            TimeRange timeRange = this.timeRange;
            boolean needsCardinality = this.statsFunction.equals((Object)StatisticalFunction.CARDINALITY);
            boolean needsCount = this.statsFunction.equals((Object)StatisticalFunction.COUNT);
            FieldStatsResult fieldStatsResult = this.getSearches().fieldStats(this.field, this.query, filter, timeRange, needsCardinality, !needsCount && !needsCardinality, needsCount);
            if (this.trend.booleanValue() && timeRange instanceof RelativeRange) {
                DateTime toPrevious = timeRange.getFrom();
                DateTime fromPrevious = toPrevious.minus((ReadablePeriod)Seconds.seconds((int)((RelativeRange)timeRange).getRange()));
                AbsoluteRange previousTimeRange = AbsoluteRange.create(fromPrevious, toPrevious);
                FieldStatsResult previousFieldStatsResult = this.getSearches().fieldStats(this.field, this.query, filter, previousTimeRange, needsCardinality, !needsCount && !needsCardinality, needsCount);
                HashMap results = Maps.newHashMap();
                results.put("now", this.getStatisticalValue(fieldStatsResult));
                results.put("previous", this.getStatisticalValue(previousFieldStatsResult));
                long tookMs = fieldStatsResult.tookMs() + previousFieldStatsResult.tookMs();
                return new ComputationResult(results, tookMs);
            }
            return new ComputationResult(this.getStatisticalValue(fieldStatsResult), fieldStatsResult.tookMs());
        }
        catch (FieldTypeException e) {
            log.warn("Invalid field provided, returning 'NaN'", (Throwable)e);
            return new ComputationResult(Double.NaN, 0L);
        }
    }

    public static enum StatisticalFunction {
        COUNT("count"),
        MEAN("mean"),
        STANDARD_DEVIATION("std_deviation"),
        MIN("min"),
        MAX("max"),
        SUM("sum"),
        VARIANCE("variance"),
        SUM_OF_SQUARES("squares"),
        CARDINALITY("cardinality");

        private final String function;

        private StatisticalFunction(String function) {
            this.function = function;
        }

        public String toString() {
            return this.function;
        }

        public static StatisticalFunction fromString(String function) {
            for (StatisticalFunction statisticalFunction : StatisticalFunction.values()) {
                if (!statisticalFunction.toString().equals(function)) continue;
                return statisticalFunction;
            }
            throw new IllegalArgumentException("Statistic function " + function + " is not supported");
        }
    }

    public static interface Factory
    extends WidgetStrategy.Factory<StatisticalCountWidgetStrategy> {
        @Override
        public StatisticalCountWidgetStrategy create(Map<String, Object> var1, TimeRange var2, String var3);
    }
}

