/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.rotation.strategies;

import java.text.MessageFormat;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.indexer.IndexNotFoundException;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.rotation.strategies.AbstractRotationStrategy;
import org.graylog2.indexer.rotation.strategies.MessageCountRotationStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.graylog2.plugin.system.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageCountRotationStrategy
extends AbstractRotationStrategy {
    private static final Logger log = LoggerFactory.getLogger(MessageCountRotationStrategy.class);
    private final Indices indices;

    @Inject
    public MessageCountRotationStrategy(Indices indices, NodeId nodeId, AuditEventSender auditEventSender) {
        super(auditEventSender, nodeId);
        this.indices = indices;
    }

    @Override
    public Class<? extends RotationStrategyConfig> configurationClass() {
        return MessageCountRotationStrategyConfig.class;
    }

    @Override
    public RotationStrategyConfig defaultConfiguration() {
        return MessageCountRotationStrategyConfig.createDefault();
    }

    @Override
    @Nullable
    protected Result shouldRotate(String index, IndexSet indexSet) {
        if (!(indexSet.getConfig().rotationStrategy() instanceof MessageCountRotationStrategyConfig)) {
            throw new IllegalStateException("Invalid rotation strategy config <" + indexSet.getConfig().rotationStrategy().getClass().getCanonicalName() + "> for index set <" + indexSet.getConfig().id() + ">");
        }
        MessageCountRotationStrategyConfig config = (MessageCountRotationStrategyConfig)indexSet.getConfig().rotationStrategy();
        try {
            long numberOfMessages = this.indices.numberOfMessages(index);
            return new Result(index, numberOfMessages, config.maxDocsPerIndex(), numberOfMessages > (long)config.maxDocsPerIndex());
        }
        catch (IndexNotFoundException e) {
            log.error("Unknown index, cannot perform rotation", (Throwable)e);
            return null;
        }
    }

    private static class Result
    implements AbstractRotationStrategy.Result {
        public static final MessageFormat ROTATE_FORMAT = new MessageFormat("Number of messages in <{0}> ({1}) is higher than the limit ({2}). Pointing deflector to new index now!", Locale.ENGLISH);
        public static final MessageFormat NOT_ROTATE_FORMAT = new MessageFormat("Number of messages in <{0}> ({1}) is lower than the limit ({2}). Not doing anything.", Locale.ENGLISH);
        private final String index;
        private final long actualCount;
        private final long maxDocs;
        private final boolean shouldRotate;

        public Result(String index, long actualCount, long maxDocs, boolean shouldRotate) {
            this.index = index;
            this.actualCount = actualCount;
            this.maxDocs = maxDocs;
            this.shouldRotate = shouldRotate;
        }

        @Override
        public String getDescription() {
            MessageFormat format = this.shouldRotate ? ROTATE_FORMAT : NOT_ROTATE_FORMAT;
            return format.format(new Object[]{this.index, this.actualCount, this.maxDocs});
        }

        @Override
        public boolean shouldRotate() {
            return this.shouldRotate;
        }
    }
}

