/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.syslog.tcp;

import org.graylog2.inputs.syslog.tcp.SyslogOctetCountFrameDecoder;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.frame.DelimiterBasedFrameDecoder;

public class SyslogTCPFramingRouterHandler
extends SimpleChannelUpstreamHandler {
    private final int maxFrameLength;
    private final ChannelBuffer[] delimiter;
    private boolean routed = false;

    public SyslogTCPFramingRouterHandler(int maxFrameLength, ChannelBuffer[] delimiter) {
        this.maxFrameLength = maxFrameLength;
        this.delimiter = delimiter;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ChannelBuffer message = (ChannelBuffer)e.getMessage();
        if (!message.readable()) {
            return;
        }
        if (!this.routed) {
            if (this.usesOctetCountFraming(message)) {
                ctx.getPipeline().addAfter(ctx.getName(), "framer-octet", (ChannelHandler)new SyslogOctetCountFrameDecoder());
            } else {
                ctx.getPipeline().addAfter(ctx.getName(), "framer-delimiter", (ChannelHandler)new DelimiterBasedFrameDecoder(this.maxFrameLength, this.delimiter));
            }
            this.routed = true;
        }
        ctx.sendUpstream((ChannelEvent)e);
    }

    private boolean usesOctetCountFraming(ChannelBuffer message) {
        return 48 < message.getByte(0) && message.getByte(0) <= 57;
    }
}

