/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup.adapters;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.floreysoft.jmte.Engine;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.inject.assistedinject.Assisted;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.graylog2.lookup.adapters.$AutoValue_HTTPJSONPathDataAdapter_Config;
import org.graylog2.plugin.lookup.LookupCachePurge;
import org.graylog2.plugin.lookup.LookupDataAdapter;
import org.graylog2.plugin.lookup.LookupDataAdapterConfiguration;
import org.graylog2.plugin.lookup.LookupResult;
import org.hibernate.validator.constraints.NotEmpty;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPJSONPathDataAdapter
extends LookupDataAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(HTTPJSONPathDataAdapter.class);
    public static final String NAME = "httpjsonpath";
    private final Config config;
    private final Engine templateEngine;
    private final OkHttpClient httpClient;
    private final Timer httpRequestTimer;
    private final Meter httpRequestErrors;
    private final Meter httpURLErrors;
    private JsonPath singleJsonPath = null;
    private JsonPath multiJsonPath = null;
    private Headers headers;

    @Inject
    protected HTTPJSONPathDataAdapter(@Assisted LookupDataAdapterConfiguration config, @Assisted(value="id") String id, @Assisted(value="name") String name, Engine templateEngine, OkHttpClient httpClient, MetricRegistry metricRegistry) {
        super(id, name, config, metricRegistry);
        this.config = (Config)config;
        this.templateEngine = templateEngine;
        this.httpClient = httpClient.newBuilder().build();
        this.httpRequestTimer = metricRegistry.timer(MetricRegistry.name(((Object)((Object)this)).getClass(), (String[])new String[]{"httpRequestTime"}));
        this.httpRequestErrors = metricRegistry.meter(MetricRegistry.name(((Object)((Object)this)).getClass(), (String[])new String[]{"httpRequestErrors"}));
        this.httpURLErrors = metricRegistry.meter(MetricRegistry.name(((Object)((Object)this)).getClass(), (String[])new String[]{"httpURLErrors"}));
    }

    @Override
    protected void doStart() throws Exception {
        if (Strings.isNullOrEmpty((String)this.config.url())) {
            throw new IllegalArgumentException("URL needs to be set");
        }
        if (Strings.isNullOrEmpty((String)this.config.singleValueJSONPath())) {
            throw new IllegalArgumentException("Value JSONPath needs to be set");
        }
        this.singleJsonPath = JsonPath.compile((String)this.config.singleValueJSONPath(), (Predicate[])new Predicate[0]);
        if (!this.singleJsonPath.isDefinite()) {
            throw new IllegalArgumentException("Single JSONPath <" + this.config.singleValueJSONPath() + "> cannot return a list");
        }
        if (this.config.multiValueJSONPath().isPresent() && !Strings.isNullOrEmpty((String)this.config.multiValueJSONPath().get())) {
            this.multiJsonPath = JsonPath.compile((String)this.config.multiValueJSONPath().get(), (Predicate[])new Predicate[0]);
        }
        this.headers = new Headers.Builder().add("User-Agent", this.config.userAgent()).add("Accept", "application/json").build();
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    public Duration refreshInterval() {
        return Duration.ZERO;
    }

    @Override
    protected void doRefresh(LookupCachePurge cachePurge) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected LookupResult doGet(Object key) {
        String encodedKey;
        try {
            encodedKey = URLEncoder.encode(String.valueOf(key), "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException ignored) {
            encodedKey = String.valueOf(key);
        }
        String urlString = this.templateEngine.transform(this.config.url(), (Map)ImmutableMap.of((Object)"key", (Object)encodedKey));
        HttpUrl url = HttpUrl.parse((String)urlString);
        if (url == null) {
            LOG.error("Couldn't parse URL <%s> - returning empty result", (Object)urlString);
            this.httpURLErrors.mark();
            return LookupResult.empty();
        }
        Request request = new Request.Builder().get().url(url).headers(this.headers).build();
        Timer.Context time = this.httpRequestTimer.time();
        try {
            LookupResult lookupResult;
            Object object;
            Response response;
            block27: {
                block28: {
                    block24: {
                        LookupResult lookupResult2;
                        block25: {
                            block26: {
                                response = this.httpClient.newCall(request).execute();
                                object = null;
                                if (response.isSuccessful()) break block24;
                                LOG.warn("HTTP request for key <{}> failed: {}", key, (Object)response);
                                this.httpRequestErrors.mark();
                                lookupResult2 = LookupResult.empty();
                                if (response == null) break block25;
                                if (object == null) break block26;
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                                break block25;
                            }
                            response.close();
                        }
                        return lookupResult2;
                    }
                    lookupResult = HTTPJSONPathDataAdapter.parseBody(this.singleJsonPath, this.multiJsonPath, response.body().byteStream());
                    if (response == null) break block27;
                    if (object == null) break block28;
                    try {
                        response.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    break block27;
                }
                response.close();
            }
            return lookupResult;
            catch (Throwable throwable) {
                try {
                    try {
                        object = throwable;
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (response != null) {
                            if (object != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)object).addSuppressed(throwable3);
                                }
                            } else {
                                response.close();
                            }
                        }
                        throw throwable2;
                    }
                }
                catch (IOException e) {
                    LOG.error("HTTP request error for key <{}>", key, (Object)e);
                    this.httpRequestErrors.mark();
                    object = LookupResult.empty();
                    return object;
                }
            }
        }
        finally {
            time.stop();
        }
    }

    @VisibleForTesting
    static LookupResult parseBody(JsonPath singleJsonPath, @Nullable JsonPath multiJsonPath, InputStream body) {
        try {
            DocumentContext documentContext = JsonPath.parse((InputStream)body);
            LookupResult.Builder builder = LookupResult.builder().cacheTTL(Long.MAX_VALUE);
            if (multiJsonPath != null) {
                try {
                    Object multiValue = documentContext.read(multiJsonPath);
                    builder = multiValue instanceof Map ? builder.multiValue((Map)multiValue) : builder.multiSingleton(multiValue);
                }
                catch (PathNotFoundException e) {
                    LOG.warn("Couldn't read multi JSONPath from response - skipping multi value ({})", (Object)e.getMessage());
                }
            }
            try {
                Object singleValue = documentContext.read(singleJsonPath);
                if (singleValue instanceof CharSequence) {
                    return builder.single((CharSequence)singleValue).build();
                }
                if (singleValue instanceof Number) {
                    return builder.single((Number)singleValue).build();
                }
                if (singleValue instanceof Boolean) {
                    return builder.single((Boolean)singleValue).build();
                }
                throw new IllegalArgumentException("Single value data type cannot be: " + singleValue.getClass().getCanonicalName());
            }
            catch (PathNotFoundException e) {
                LOG.warn("Couldn't read single JSONPath from response - returning empty result ({})", (Object)e.getMessage());
                return LookupResult.empty();
            }
        }
        catch (InvalidJsonException e) {
            LOG.error("Couldn't parse JSON response", (Throwable)e);
            return LookupResult.empty();
        }
        catch (ClassCastException e) {
            LOG.error("Couldn't assign value type", (Throwable)e);
            return LookupResult.empty();
        }
        catch (Exception e) {
            LOG.error("Unexpected error parsing JSON response", (Throwable)e);
            return LookupResult.empty();
        }
    }

    @Override
    public void set(Object key, Object value) {
    }

    @JsonAutoDetect
    @JsonDeserialize(builder=$AutoValue_HTTPJSONPathDataAdapter_Config.Builder.class)
    @JsonTypeName(value="httpjsonpath")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static abstract class Config
    implements LookupDataAdapterConfiguration {
        @Override
        @JsonProperty(value="type")
        public abstract String type();

        @JsonProperty(value="url")
        @NotEmpty
        public abstract String url();

        @JsonProperty(value="single_value_jsonpath")
        @NotEmpty
        public abstract String singleValueJSONPath();

        @JsonProperty(value="multi_value_jsonpath")
        public abstract Optional<String> multiValueJSONPath();

        @JsonProperty(value="user_agent")
        @NotEmpty
        public abstract String userAgent();

        public static Builder builder() {
            return new $AutoValue_HTTPJSONPathDataAdapter_Config.Builder();
        }

        @Override
        public Optional<Multimap<String, String>> validate() {
            ArrayListMultimap errors = ArrayListMultimap.create();
            if (HttpUrl.parse((String)this.url()) == null) {
                errors.put((Object)"url", (Object)"Invalid URL.");
            }
            try {
                JsonPath jsonPath = JsonPath.compile((String)this.singleValueJSONPath(), (Predicate[])new Predicate[0]);
                if (!jsonPath.isDefinite()) {
                    errors.put((Object)"single_value_jsonpath", (Object)"JSONPath does not return a single value.");
                }
            }
            catch (InvalidPathException e) {
                errors.put((Object)"single_value_jsonpath", (Object)"Invalid JSONPath.");
            }
            if (this.multiValueJSONPath().isPresent()) {
                try {
                    JsonPath.compile((String)this.multiValueJSONPath().get(), (Predicate[])new Predicate[0]);
                }
                catch (InvalidPathException e) {
                    errors.put((Object)"multi_value_jsonpath", (Object)"Invalid JSONPath.");
                }
            }
            return errors.isEmpty() ? Optional.empty() : Optional.of(errors);
        }

        public static abstract class Builder {
            @JsonProperty(value="type")
            public abstract Builder type(String var1);

            @JsonProperty(value="url")
            public abstract Builder url(String var1);

            @JsonProperty(value="single_value_jsonpath")
            public abstract Builder singleValueJSONPath(String var1);

            @JsonProperty(value="multi_value_jsonpath")
            public abstract Builder multiValueJSONPath(String var1);

            @JsonProperty(value="user_agent")
            public abstract Builder userAgent(String var1);

            public abstract Config build();
        }
    }

    public static class Descriptor
    extends LookupDataAdapter.Descriptor<Config> {
        public Descriptor() {
            super(HTTPJSONPathDataAdapter.NAME, Config.class);
        }

        @Override
        public Config defaultConfiguration() {
            return Config.builder().type(HTTPJSONPathDataAdapter.NAME).url("").singleValueJSONPath("$.value").userAgent("Graylog Lookup - https://www.graylog.org/").build();
        }
    }

    public static interface Factory
    extends LookupDataAdapter.Factory<HTTPJSONPathDataAdapter> {
        @Override
        public HTTPJSONPathDataAdapter create(@Assisted(value="id") String var1, @Assisted(value="name") String var2, LookupDataAdapterConfiguration var3);

        @Override
        public Descriptor getDescriptor();
    }
}

