/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import java.time.ZonedDateTime;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.MongoIndexSet;
import org.graylog2.indexer.cluster.Cluster;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indexset.IndexSetService;
import org.graylog2.indexer.indices.TooManyAliasesException;
import org.graylog2.indexer.ranges.CreateNewSingleIndexRangeJob;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.ranges.IndexRangeService;
import org.graylog2.migrations.Migration;
import org.mongojack.DBQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20161130141500_DefaultStreamRecalcIndexRanges
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20161130141500_DefaultStreamRecalcIndexRanges.class);
    private final IndexSetRegistry indexSetRegistry;
    private final IndexSetService indexSetService;
    private final MongoIndexSet.Factory indexSetFactory;
    private final IndexRangeService indexRangeService;
    private final CreateNewSingleIndexRangeJob.Factory rebuildIndexRangeJobFactory;
    private final Cluster cluster;

    @Inject
    public V20161130141500_DefaultStreamRecalcIndexRanges(IndexSetRegistry indexSetRegistry, IndexSetService indexSetService, MongoIndexSet.Factory indexSetFactory, IndexRangeService indexRangeService, CreateNewSingleIndexRangeJob.Factory rebuildIndexRangeJobFactory, Cluster cluster) {
        this.indexSetRegistry = indexSetRegistry;
        this.indexSetService = indexSetService;
        this.indexSetFactory = indexSetFactory;
        this.indexRangeService = indexRangeService;
        this.rebuildIndexRangeJobFactory = rebuildIndexRangeJobFactory;
        this.cluster = cluster;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2016-11-30T14:15:00Z");
    }

    @Override
    public void upgrade() {
        String currentWriteTarget;
        Set indexRangesWithoutStreams;
        IndexSet indexSet;
        try {
            indexSet = this.indexSetRegistry.getDefault();
        }
        catch (IllegalStateException e) {
            IndexSetConfig indexSetConfig = this.indexSetService.findOne(DBQuery.is((String)"default", (Object)true)).orElseThrow(() -> new IllegalStateException("No default index set configured! This is a bug!"));
            indexSet = this.indexSetFactory.create(indexSetConfig);
        }
        IndexSet defaultIndexSet = indexSet;
        if (!this.cluster.isConnected()) {
            LOG.info("Cluster not connected yet, delaying migration until it is reachable.");
            while (true) {
                try {
                    this.cluster.waitForConnectedAndDeflectorHealthy();
                }
                catch (InterruptedException | TimeoutException e) {
                    LOG.warn("Interrupted or timed out waiting for Elasticsearch cluster, checking again.");
                    continue;
                }
                break;
            }
        }
        if ((indexRangesWithoutStreams = this.indexRangeService.findAll().stream().filter(indexRange -> defaultIndexSet.isManagedIndex(indexRange.indexName())).filter(indexRange -> indexRange.streamIds() == null).map(IndexRange::indexName).collect(Collectors.toSet())).size() == 0) {
            return;
        }
        try {
            currentWriteTarget = defaultIndexSet.getActiveWriteIndex();
        }
        catch (TooManyAliasesException e) {
            LOG.error("Multiple write targets found for write alias. Cannot continue to assign streams to older indices", (Throwable)e);
            return;
        }
        for (String indexName : defaultIndexSet.getManagedIndices()) {
            if (indexName.equals(currentWriteTarget) || !indexRangesWithoutStreams.contains(indexName)) continue;
            LOG.info("Recalculating streams in index {}", (Object)indexName);
            CreateNewSingleIndexRangeJob createNewSingleIndexRangeJob = this.rebuildIndexRangeJobFactory.create(this.indexSetRegistry.getAll(), indexName);
            createNewSingleIndexRangeJob.execute();
        }
    }
}

