/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import com.github.joschi.jadconfig.util.Duration;
import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.EventBus;
import com.google.common.primitives.Ints;
import com.google.inject.name.Named;
import java.util.HashSet;
import java.util.Objects;
import java.util.SortedSet;
import javax.inject.Inject;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.cluster.Cluster;
import org.graylog2.indexer.indices.events.IndicesDeletedEvent;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.ranges.IndexRangeService;
import org.graylog2.plugin.periodical.Periodical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexRangesCleanupPeriodical
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(IndexRangesCleanupPeriodical.class);
    private final Cluster cluster;
    private final IndexSetRegistry indexSetRegistry;
    private final IndexRangeService indexRangeService;
    private final EventBus eventBus;
    private final int periodSeconds;

    @Inject
    public IndexRangesCleanupPeriodical(Cluster cluster, IndexSetRegistry indexSetRegistry, IndexRangeService indexRangeService, EventBus eventBus, @Named(value="index_ranges_cleanup_interval") Duration indexRangesCleanupInterval) {
        this.cluster = Objects.requireNonNull(cluster);
        this.indexSetRegistry = Objects.requireNonNull(indexSetRegistry);
        this.indexRangeService = Objects.requireNonNull(indexRangeService);
        this.eventBus = Objects.requireNonNull(eventBus);
        this.periodSeconds = Ints.saturatedCast((long)indexRangesCleanupInterval.toSeconds());
    }

    @Override
    public void doRun() {
        if (!this.cluster.isConnected() || !this.cluster.isHealthy()) {
            LOG.info("Skipping index range cleanup because the Elasticsearch cluster is unreachable or unhealthy");
            return;
        }
        ImmutableSet indexNames = ImmutableSet.copyOf((Object[])this.indexSetRegistry.getManagedIndices());
        SortedSet<IndexRange> indexRanges = this.indexRangeService.findAll();
        HashSet<String> removedIndices = new HashSet<String>();
        for (IndexRange indexRange : indexRanges) {
            if (indexNames.contains(indexRange.indexName())) continue;
            removedIndices.add(indexRange.indexName());
        }
        if (!removedIndices.isEmpty()) {
            LOG.info("Removing index range information for unavailable indices: {}", removedIndices);
            this.eventBus.post((Object)IndicesDeletedEvent.create(removedIndices));
        }
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean masterOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 15;
    }

    @Override
    public int getPeriodSeconds() {
        return this.periodSeconds;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

