/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.models;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ForwardingList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class PaginatedList<E>
extends ForwardingList<E> {
    private final List<E> delegate;
    private final PaginationInfo paginationInfo;

    public PaginatedList(@Nonnull List<E> delegate, int globalTotal, int page, int perPage) {
        this.delegate = delegate;
        this.paginationInfo = new PaginationInfo(globalTotal, page, perPage);
    }

    public List<E> delegate() {
        return this.delegate;
    }

    public PaginationInfo pagination() {
        return this.paginationInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PaginatedList)) {
            return false;
        }
        PaginatedList that = (PaginatedList)((Object)o);
        return Objects.equals(this.pagination(), that.pagination()) && Objects.equals(this.delegate(), that.delegate());
    }

    public int hashCode() {
        return Objects.hash(this.delegate(), this.pagination());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("content", this.delegate).add("pagination_info", (Object)this.pagination()).toString();
    }

    public static <T> PaginatedList<T> emptyList(int page, int perPage) {
        return new PaginatedList(Collections.emptyList(), 0, page, perPage);
    }

    public static <T> PaginatedList<T> singleton(T entry, int page, int perPage) {
        return new PaginatedList<T>(Collections.singletonList(entry), 1, page, perPage);
    }

    @JsonAutoDetect
    public class PaginationInfo {
        @JsonProperty(value="total")
        private final int globalTotal;
        @JsonProperty(value="page")
        private final int page;
        @JsonProperty(value="per_page")
        private final int perPage;

        public PaginationInfo(int globalTotal, int page, int perPage) {
            this.globalTotal = globalTotal;
            this.page = page;
            this.perPage = perPage;
        }

        @JsonProperty(value="count")
        public int getCount() {
            return PaginatedList.this.delegate().size();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PaginationInfo)) {
                return false;
            }
            PaginationInfo that = (PaginationInfo)o;
            return this.globalTotal == that.globalTotal && this.page == that.page && this.perPage == that.perPage;
        }

        public int hashCode() {
            return Objects.hash(this.globalTotal, this.page, this.perPage);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("globalTotal", this.globalTotal).add("page", this.page).add("perPage", this.perPage).toString();
        }
    }
}

