/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.net.URI;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.graylog2.Configuration;
import org.graylog2.plugin.Version;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.cluster.ClusterId;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.rest.models.HelloWorldResponse;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="Hello World", description="A friendly hello world message")
@Path(value="/")
public class HelloWorldResource
extends RestResource {
    private final NodeId nodeId;
    private final ClusterConfigService clusterConfigService;
    private final Configuration configuration;

    @Inject
    public HelloWorldResource(NodeId nodeId, ClusterConfigService clusterConfigService, Configuration configuration) {
        this.nodeId = Objects.requireNonNull(nodeId);
        this.clusterConfigService = Objects.requireNonNull(clusterConfigService);
        this.configuration = configuration;
    }

    @GET
    @Timed
    @ApiOperation(value="A few details about the Graylog node.")
    @Produces(value={"application/json"})
    public HelloWorldResponse helloWorld() {
        ClusterId clusterId = this.clusterConfigService.getOrDefault(ClusterId.class, ClusterId.create("UNKNOWN"));
        return HelloWorldResponse.create(clusterId.clusterId(), this.nodeId.toString(), Version.CURRENT_CLASSPATH.toString(), "Manage your logs in the dark and have lasers going and make it look like you're from space!");
    }

    @GET
    @Timed
    @ApiOperation(value="Redirecting to web console if it runs on same port.")
    @Produces(value={"text/html", "application/xhtml+xml"})
    public Response redirectToWebConsole() {
        if (this.configuration.isRestAndWebOnSamePort()) {
            URI target = URI.create(this.configuration.getWebPrefix());
            return Response.temporaryRedirect((URI)target).build();
        }
        return Response.ok((Object)this.helloWorld()).type("application/json").build();
    }
}

