/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="System/Fields", description="Get list of message fields that exist.")
@Path(value="/system/fields")
public class SystemFieldsResource
extends RestResource {
    private final Indices indices;
    private final IndexSetRegistry indexSetRegistry;

    @Inject
    public SystemFieldsResource(Indices indices, IndexSetRegistry indexSetRegistry) {
        this.indices = indices;
        this.indexSetRegistry = indexSetRegistry;
    }

    @GET
    @Timed
    @ApiOperation(value="Get list of message fields that exist", notes="This operation is comparably fast because it reads directly from the indexer mapping.")
    @RequiresPermissions(value={"fieldnames:read"})
    @Produces(value={"application/json"})
    public Map<String, Set<String>> fields(@ApiParam(name="limit", value="Maximum number of fields to return. Set to 0 for all fields.", required=false) @QueryParam(value="limit") int limit) {
        Set<Object> fields;
        boolean unlimited = limit <= 0;
        String[] writeIndexWildcards = this.indexSetRegistry.getIndexWildcards();
        if (unlimited) {
            fields = this.indices.getAllMessageFields(writeIndexWildcards);
        } else {
            fields = Sets.newHashSetWithExpectedSize((int)limit);
            this.addStandardFields((Set<String>)fields);
            int i = 0;
            for (String field : this.indices.getAllMessageFields(writeIndexWildcards)) {
                if (i == limit) break;
                fields.add(field);
                ++i;
            }
        }
        return ImmutableMap.of((Object)"fields", (Object)fields);
    }

    private void addStandardFields(Set<String> fields) {
        fields.add("source");
        fields.add("message");
        fields.add("timestamp");
    }
}

