/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.graylog2.rest.resources.system.indexer.requests.AutoValue_IndexSetUpdateRequest;
import org.hibernate.validator.constraints.NotBlank;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class IndexSetUpdateRequest {
    @JsonProperty(value="title")
    @NotBlank
    public abstract String title();

    @JsonProperty(value="description")
    @Nullable
    public abstract String description();

    @JsonProperty(value="writable")
    public abstract boolean isWritable();

    @JsonProperty(value="shards")
    @Min(value=1L)
    public abstract int shards();

    @JsonProperty(value="replicas")
    @Min(value=0L)
    public abstract int replicas();

    @JsonProperty(value="rotation_strategy_class")
    @NotNull
    public abstract String rotationStrategyClass();

    @JsonProperty(value="rotation_strategy")
    @NotNull
    public abstract RotationStrategyConfig rotationStrategy();

    @JsonProperty(value="retention_strategy_class")
    @NotNull
    public abstract String retentionStrategyClass();

    @JsonProperty(value="retention_strategy")
    @NotNull
    public abstract RetentionStrategyConfig retentionStrategy();

    @JsonProperty(value="index_optimization_max_num_segments")
    @Min(value=1L)
    public abstract int indexOptimizationMaxNumSegments();

    @JsonProperty(value="index_optimization_disabled")
    public abstract boolean indexOptimizationDisabled();

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static IndexSetUpdateRequest create(@JsonProperty(value="title") @NotBlank String title, @JsonProperty(value="description") @Nullable String description, @JsonProperty(value="writable") boolean isWritable, @JsonProperty(value="shards") @Min(value=1L) int shards, @JsonProperty(value="replicas") @Min(value=0L) int replicas, @JsonProperty(value="rotation_strategy_class") @NotNull String rotationStrategyClass, @JsonProperty(value="rotation_strategy") @NotNull RotationStrategyConfig rotationStrategy, @JsonProperty(value="retention_strategy_class") @NotNull String retentionStrategyClass, @JsonProperty(value="retention_strategy") @NotNull RetentionStrategyConfig retentionStrategy, @JsonProperty(value="index_optimization_max_num_segments") @Min(value=1L) int indexOptimizationMaxNumSegments, @JsonProperty(value="index_optimization_disabled") boolean indexOptimizationDisabled) {
        return new AutoValue_IndexSetUpdateRequest(title, description, isWritable, shards, replicas, rotationStrategyClass, rotationStrategy, retentionStrategyClass, retentionStrategy, indexOptimizationMaxNumSegments, indexOptimizationDisabled);
    }

    public static IndexSetUpdateRequest fromIndexSetConfig(IndexSetConfig indexSet) {
        return IndexSetUpdateRequest.create(indexSet.title(), indexSet.description(), indexSet.isWritable(), indexSet.shards(), indexSet.replicas(), indexSet.rotationStrategyClass(), indexSet.rotationStrategy(), indexSet.retentionStrategyClass(), indexSet.retentionStrategy(), indexSet.indexOptimizationMaxNumSegments(), indexSet.indexOptimizationDisabled());
    }

    public IndexSetConfig toIndexSetConfig(String id, IndexSetConfig oldConfig) {
        return IndexSetConfig.builder().id(id).title(this.title()).description(this.description()).isWritable(this.isWritable()).indexPrefix(oldConfig.indexPrefix()).indexMatchPattern(oldConfig.indexMatchPattern()).indexWildcard(oldConfig.indexWildcard()).shards(this.shards()).replicas(this.replicas()).rotationStrategyClass(this.rotationStrategyClass()).rotationStrategy(this.rotationStrategy()).retentionStrategyClass(this.retentionStrategyClass()).retentionStrategy(this.retentionStrategy()).creationDate(oldConfig.creationDate()).indexAnalyzer(oldConfig.indexAnalyzer()).indexTemplateName(oldConfig.indexTemplateName()).indexOptimizationMaxNumSegments(this.indexOptimizationMaxNumSegments()).indexOptimizationDisabled(this.indexOptimizationDisabled()).build();
    }
}

