/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security.realm;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.util.ByteSource;
import org.graylog2.plugin.database.users.User;
import org.graylog2.security.realm.PasswordAlgorithmCredentialsMatcher;
import org.graylog2.security.realm.UserAccount;
import org.graylog2.shared.users.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordAuthenticator
extends AuthenticatingRealm {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordAuthenticator.class);
    public static final String NAME = "mongodb-password";
    private final UserService userService;
    private ByteSource credentialsSalt;

    @Inject
    PasswordAuthenticator(UserService userService, @Named(value="password_secret") String passwordSecret, PasswordAlgorithmCredentialsMatcher passwordAlgorithmCredentialsMatcher) {
        this.userService = userService;
        this.credentialsSalt = ByteSource.Util.bytes((String)passwordSecret);
        this.setCachingEnabled(false);
        this.setCredentialsMatcher((CredentialsMatcher)passwordAlgorithmCredentialsMatcher);
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authToken) throws AuthenticationException {
        UsernamePasswordToken token = (UsernamePasswordToken)authToken;
        LOG.debug("Retrieving authc info for user {}", (Object)token.getUsername());
        User user = this.userService.load(token.getUsername());
        if (user == null || user.isLocalAdmin()) {
            return null;
        }
        if (user.isExternalUser()) {
            LOG.trace("Skipping mongodb-based password check for LDAP user {}", (Object)token.getUsername());
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found user {} to be authenticated with password.", (Object)user.getName());
        }
        return new UserAccount(token.getPrincipal(), (Object)user.getHashedPassword(), this.credentialsSalt, "graylog2MongoDbRealm", user);
    }
}

