/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.bindings.providers;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import java.lang.management.ManagementFactory;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class MetricRegistryProvider
implements Provider<MetricRegistry> {
    private final MetricRegistry metricRegistry = new MetricRegistry();

    public MetricRegistryProvider() {
        this.metricRegistry.register("jvm.buffers", (Metric)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        this.metricRegistry.register("jvm.cl", (Metric)new ClassLoadingGaugeSet());
        this.metricRegistry.register("jvm.gc", (Metric)new GarbageCollectorMetricSet());
        this.metricRegistry.register("jvm.memory", (Metric)new MemoryUsageGaugeSet());
        this.metricRegistry.register("jvm.threads", (Metric)new ThreadStatesGaugeSet());
    }

    public MetricRegistry get() {
        return this.metricRegistry;
    }
}

