/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.buffers;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.lmax.disruptor.EventHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog2.shared.buffers.RawMessageEvent;
import org.graylog2.shared.journal.Journal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournallingMessageHandler
implements EventHandler<RawMessageEvent> {
    private static final Logger log = LoggerFactory.getLogger(JournallingMessageHandler.class);
    private static final Set<Journal.Entry> NULL_SINGLETON = Collections.singleton(null);
    private static final Retryer<Void> JOURNAL_WRITE_RETRYER = RetryerBuilder.newBuilder().retryIfException((Predicate)new Predicate<Throwable>(){

        public boolean apply(@Nullable Throwable input) {
            log.error("Unable to write to journal - retrying with exponential back-off", input);
            return true;
        }
    }).withWaitStrategy(WaitStrategies.exponentialWait((long)250L, (long)1L, (TimeUnit)TimeUnit.MINUTES)).withStopStrategy(StopStrategies.neverStop()).build();
    private final List<RawMessageEvent> batch = Lists.newArrayList();
    private final Counter byteCounter;
    private final Journal journal;
    private final Semaphore journalFilled;

    @Inject
    public JournallingMessageHandler(MetricRegistry metrics, Journal journal, @Named(value="JournalSignal") Semaphore journalFilled) {
        this.journal = journal;
        this.journalFilled = journalFilled;
        this.byteCounter = metrics.counter(MetricRegistry.name(JournallingMessageHandler.class, (String[])new String[]{"written_bytes"}));
    }

    public void onEvent(RawMessageEvent event, long sequence, boolean endOfBatch) throws Exception {
        this.batch.add(event);
        if (endOfBatch) {
            log.debug("End of batch, journalling {} messages", (Object)this.batch.size());
            final Converter converter = new Converter();
            final ArrayList entries = Lists.newArrayList((Iterable)Lists.transform(this.batch, (Function)converter));
            entries.removeAll(NULL_SINGLETON);
            this.batch.clear();
            try {
                this.writeToJournal(converter, entries);
            }
            catch (Exception e) {
                log.error("Unable to write to journal - retrying", (Throwable)e);
                JOURNAL_WRITE_RETRYER.call((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        JournallingMessageHandler.this.writeToJournal(converter, entries);
                        return null;
                    }
                });
            }
        }
    }

    private void writeToJournal(Converter converter, List<Journal.Entry> entries) {
        long lastOffset = this.journal.write(entries);
        log.debug("Processed batch, wrote {} bytes, last journal offset: {}, signalling reader.", (Object)converter.getBytesWritten(), (Object)lastOffset);
        this.journalFilled.release();
    }

    private class Converter
    implements Function<RawMessageEvent, Journal.Entry> {
        private long bytesWritten = 0L;

        private Converter() {
        }

        public long getBytesWritten() {
            return this.bytesWritten;
        }

        @Nullable
        public Journal.Entry apply(RawMessageEvent input) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace("Journalling message {}", (Object)input.getMessageId());
                }
                byte[] messageIdBytes = input.getMessageIdBytes();
                byte[] encodedRawMessage = input.getEncodedRawMessage();
                int size = encodedRawMessage.length;
                this.bytesWritten += (long)size;
                JournallingMessageHandler.this.byteCounter.inc((long)size);
                input.setMessageIdBytes(null);
                input.setEncodedRawMessage(null);
                return JournallingMessageHandler.this.journal.createEntry(messageIdBytes, encodedRawMessage);
            }
            catch (Exception e) {
                log.error("Unable to convert RawMessageEvent to Journal.Entry - skipping event", (Throwable)e);
                return null;
            }
        }
    }
}

