/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.metrics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.util.concurrent.TimeUnit;
import org.graylog2.shared.metrics.HdrHistogram;

public class HdrTimer
extends Timer {
    private final HdrHistogram hdrHistogram;

    public HdrTimer(long highestTrackableValue, TimeUnit unit, int numberOfSignificantValueDigits) {
        this(highestTrackableValue, unit, numberOfSignificantValueDigits, (Reservoir)new ExponentiallyDecayingReservoir());
    }

    public HdrTimer(long highestTrackableValue, TimeUnit unit, int numberOfSignificantValueDigits, Reservoir reservoir) {
        this(highestTrackableValue, unit, numberOfSignificantValueDigits, reservoir, Clock.defaultClock());
    }

    public HdrTimer(long highestTrackableValue, TimeUnit unit, int numberOfSignificantValueDigits, Reservoir reservoir, Clock clock) {
        super(reservoir, clock);
        this.hdrHistogram = new HdrHistogram(unit.toNanos(highestTrackableValue), numberOfSignificantValueDigits);
    }

    public long getCount() {
        return this.hdrHistogram.getCount();
    }

    public Snapshot getSnapshot() {
        return this.hdrHistogram.getSnapshot();
    }

    public void update(long duration, TimeUnit unit) {
        super.update(duration, unit);
        if (duration >= 0L) {
            this.hdrHistogram.update(unit.toNanos(duration));
        }
    }
}

