/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest;

import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Response;

public class CORSFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        String origin;
        if ("options".equalsIgnoreCase(requestContext.getRequest().getMethod())) {
            if (Response.Status.Family.familyOf((int)responseContext.getStatus()) == Response.Status.Family.SUCCESSFUL) {
                return;
            }
            responseContext.setStatus(Response.Status.NO_CONTENT.getStatusCode());
            responseContext.setEntity((Object)"");
        }
        if ((origin = (String)requestContext.getHeaders().getFirst((Object)"Origin")) != null && !origin.isEmpty()) {
            responseContext.getHeaders().add((Object)"Access-Control-Allow-Origin", (Object)origin);
            responseContext.getHeaders().add((Object)"Access-Control-Allow-Credentials", (Object)true);
            responseContext.getHeaders().add((Object)"Access-Control-Allow-Headers", (Object)"Authorization, Content-Type, X-Graylog-No-Session-Extension, X-Requested-With");
            responseContext.getHeaders().add((Object)"Access-Control-Allow-Methods", (Object)"GET, POST, PUT, DELETE, OPTIONS");
            responseContext.getHeaders().add((Object)"Access-Control-Max-Age", (Object)"600");
        }
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if ("options".equalsIgnoreCase(requestContext.getRequest().getMethod())) {
            Response.ResponseBuilder options = Response.noContent();
            String origin = (String)requestContext.getHeaders().getFirst((Object)"Origin");
            if (origin != null && !origin.isEmpty()) {
                options.header("Access-Control-Allow-Origin", (Object)origin);
                options.header("Access-Control-Allow-Credentials", (Object)true);
                options.header("Access-Control-Allow-Headers", (Object)"Authorization, Content-Type, X-Graylog-No-Session-Extension, X-Requested-With");
                options.header("Access-Control-Allow-Methods", (Object)"GET, POST, PUT, DELETE, OPTIONS");
                options.header("Access-Control-Max-Age", (Object)"600");
                requestContext.abortWith(options.build());
            }
        }
    }
}

