/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.resources;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.jaxrs.cfg.EndpointConfigBase;
import com.fasterxml.jackson.jaxrs.cfg.ObjectWriterInjector;
import com.fasterxml.jackson.jaxrs.cfg.ObjectWriterModifier;
import java.net.URI;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.shiro.subject.Subject;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.plugin.BaseConfiguration;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.security.ShiroPrincipal;
import org.graylog2.shared.users.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(RestResource.class);
    @Inject
    protected UserService userService;
    @Inject
    private BaseConfiguration configuration;
    @Context
    SecurityContext securityContext;
    @Context
    UriInfo uriInfo;

    @QueryParam(value="pretty")
    public void setPrettyPrint(boolean prettyPrint) {
        if (prettyPrint) {
            ObjectWriterInjector.set((ObjectWriterModifier)new ObjectWriterModifier(){

                public ObjectWriter modify(EndpointConfigBase<?> endpoint, MultivaluedMap<String, Object> responseHeaders, Object valueToWrite, ObjectWriter w, JsonGenerator g) {
                    return w.withDefaultPrettyPrinter();
                }
            });
        }
    }

    protected Subject getSubject() {
        if (this.securityContext == null) {
            LOG.error("Cannot retrieve current subject, SecurityContext isn't set.");
            return null;
        }
        Principal p = this.securityContext.getUserPrincipal();
        if (!(p instanceof ShiroPrincipal)) {
            String msg = "Unknown SecurityContext class " + this.securityContext + ", cannot continue.";
            LOG.error(msg);
            throw new IllegalStateException(msg);
        }
        ShiroPrincipal principal = (ShiroPrincipal)p;
        return principal.getSubject();
    }

    protected boolean isPermitted(String permission, String instanceId) {
        return this.getSubject().isPermitted(permission + ":" + instanceId);
    }

    protected void checkPermission(String permission) {
        if (!this.isPermitted(permission)) {
            throw new ForbiddenException("Not authorized");
        }
    }

    protected boolean isPermitted(String permission) {
        return this.getSubject().isPermitted(permission);
    }

    protected void checkPermission(String permission, String instanceId) {
        if (!this.isPermitted(permission, instanceId)) {
            throw new ForbiddenException("Not authorized to access resource id <" + instanceId + ">");
        }
    }

    protected boolean isAnyPermitted(String[] permissions, String instanceId) {
        List<String> instancePermissions = Arrays.stream(permissions).map(permission -> permission + ":" + instanceId).collect(Collectors.toList());
        return this.isAnyPermitted(instancePermissions.toArray(new String[0]));
    }

    protected boolean isAnyPermitted(String ... permissions) {
        boolean[] permitted;
        for (boolean p : permitted = this.getSubject().isPermitted(permissions)) {
            if (!p) continue;
            return true;
        }
        return false;
    }

    protected void checkAnyPermission(String[] permissions, String instanceId) {
        if (!this.isAnyPermitted(permissions, instanceId)) {
            throw new ForbiddenException("Not authorized to access resource id <" + instanceId + ">");
        }
    }

    @Nullable
    protected User getCurrentUser() {
        Object principal = this.getSubject().getPrincipal();
        User user = this.userService.load(principal.toString());
        if (user == null) {
            LOG.error("Loading the current user failed, this should not happen. Did you call this method in an unauthenticated REST resource?");
        }
        return user;
    }

    protected UriBuilder getUriBuilderToSelf() {
        URI restTransportUri = this.configuration.getRestTransportUri();
        if (restTransportUri != null) {
            return UriBuilder.fromUri((URI)restTransportUri);
        }
        return this.uriInfo.getBaseUriBuilder();
    }

    protected IndexSet getIndexSet(IndexSetRegistry indexSetRegistry, String indexSetId) {
        return indexSetRegistry.get(indexSetId).orElseThrow(() -> new NotFoundException("Index set <" + indexSetId + "> not found."));
    }
}

