/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security;

import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.SecurityContext;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.subject.Subject;
import org.graylog2.shared.security.ShiroSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=1000)
public class ShiroAuthenticationFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ShiroAuthenticationFilter.class);

    public void filter(ContainerRequestContext requestContext) throws IOException {
        SecurityContext securityContext = requestContext.getSecurityContext();
        if (securityContext instanceof ShiroSecurityContext) {
            ShiroSecurityContext context = (ShiroSecurityContext)securityContext;
            Subject subject = context.getSubject();
            LOG.trace("Authenticating... {}", (Object)subject);
            if (!subject.isAuthenticated()) {
                try {
                    LOG.trace("Logging in {}", (Object)subject);
                    context.loginSubject();
                }
                catch (LockedAccountException e) {
                    LOG.debug("Unable to authenticate user, account is locked.", (Throwable)e);
                    throw new NotAuthorizedException((Throwable)e, (Object)"Basic realm=\"Graylog Server\"", new Object[0]);
                }
                catch (AuthenticationException e) {
                    LOG.debug("Unable to authenticate user.", (Throwable)e);
                    throw new NotAuthorizedException((Throwable)e, (Object)"Basic realm=\"Graylog Server\"", new Object[0]);
                }
            }
        } else {
            throw new NotAuthorizedException((Object)"Basic realm=\"Graylog Server\"", new Object[0]);
        }
    }
}

